from sklearn.preprocessing import StandardScaler
from imblearn.pipeline import Pipeline
from sklearn.linear_model import LogisticRegression
from sklearn.feature_selection import VarianceThreshold
from sklearn.impute import SimpleImputer

import numpy as np

alpha_grid = np.logspace(-6, 5, 45)

# Linear evaluation models
LogReg = ( # (pipeline, grid) for Logistic Regression classifier
    Pipeline([
        ("imputer", SimpleImputer(strategy="median")),
        ("varth", VarianceThreshold()), 
        ("scale", StandardScaler()),
        ("model_LR", LogisticRegression(max_iter=1000, class_weight='balanced'))
        ]),
    {"model_LR__C" : alpha_grid}, 
)
