label_map = {
        "美食": {
            "label": 0,
            "sub_topic": {
                "食物成品展示": 0,
                "食材展示": 1,
                "吃播展示": 2,
                "主食制作展示": 3,
                "甜品制作展示": 4,
                "小吃制作展示": 5,
                "酒饮制作展示": 6,
                "美食探店": 7, 
                "城市美食打卡": 8,
                "正餐主食测评": 9,
                "酒水饮料测评": 10,
                "零食小吃测评": 11,
                "甜品测评": 12,
                "生鲜食材测评": 13,
                "美食攻略": 14, 
                "美食教学": 15,
                "美食求助": 16,
                "美食优惠": 17,
                "饮食文化": 18,
                "饮食科学": 19
            }
        },
        "明星": {
            "label": 1,
            "sub_topic": {
                "粉丝互动": 0,
                "明星安利": 1,
                "明星周边": 2,
                "追星日常": 3,
                "娱乐八卦": 4
            }
        },
        "生活记录": {
            "label": 2,
            "sub_topic": {
                "毕业生活": 0,
                "个人日常分享": 1, 
                "婚恋日常分享": 2,
                "课余生活分享": 3,
                "恋爱交友": 4,
                "亲友日常分享": 5,
                "情感互动": 6,
                "生活日常互动": 7,
                "校园互动": 8,
                "兴趣交友": 9,
                "学习日常记录": 10,
                "彩票": 11
            }
        }, 
        "游戏": {
            "label": 3,
            "sub_topic": {
                "电竞赛事": 0,
                "游戏同人创作": 1,
                "电竞追星": 2,
                "电脑游戏分享": 3, 
                "电脑游戏互动": 4,
                "密室解谜游戏": 5,
                "女性向游戏": 6,
                "棋牌游戏": 7, 
                "赛车游戏": 8,
                "手机游戏分享": 9,
                "手机游戏互动": 10,
                "音舞游戏": 11,
                "游戏日常": 12,
                "主机游戏分享": 13,
                "主机游戏互动": 14,
                "桌游": 15,
                "游戏周边": 16
            }
        },
        "科技数码": {
            "label": 4,
            "sub_topic": {
                "手持电子设备": 0,
                "玩机攻略": 1,
                "手机互动": 2,
                "手机": 3,
                "电脑": 4,
                "手机配件": 5,
                "电脑配件": 6,
                "平板": 7,
                "软件服务": 8,
                "智能助手": 9,
                "VR设备": 10,
                "智能手表": 11,
                "耳机": 12,
                "智能手环": 13,
                "投影": 14,
                "家用音响": 15,
                "电视": 16,
                "打印机": 17,
                "相机": 18,
                "通讯服务": 19,
                "科技数码其他": 20
            }
        },
        "汽车": {
            "label": 5,
            "sub_topic": {
                "机动车测评": 0,
                "机动车养护": 1,
                "机动车改装": 2,
                "机动车日常": 3,
                "车辆配件": 4,
                "车险": 5,
                "机动车服务": 6,
                "车展": 7,
                "二手车": 8,
                "摩托车": 9,
                "豪华车": 10,
                "新能源": 11,
                "燃油车": 12,
                "机动车资讯": 13,
                "机动车知识": 14
            }
        },
        "健身减肥": {
            "label": 6,
            "sub_topic":{
                "跳绳健身": 0,
                "瑜伽教学": 1,
                "瑜伽体验": 2,
                "全身燃脂运动": 3,
                "减肥记录": 4,
                "减肥教学": 5,
                "减肥互动": 6,
                "健身日常": 7,
                "健身互动": 8,
                "居家健身": 9,
                "轻食健身餐": 10,
                "增肌塑形": 11
            }
        },
        "体育运动": {
            "label": 7,
            "sub_topic":{
                "跑步运动": 0,
                "其他田径运动": 1,
                "滑雪运动": 2,
                "冰上运动项目": 3,
                "篮球运动": 4,
                "羽毛球运动": 5,
                "乒乓球运动": 6,
                "网球运动": 7,
                "足球运动": 8,
                "排球运动": 9,
                "棒球运动": 10,
                "其他球类运动": 11,
                "潜水运动": 12,
                "游泳运动": 13,
                "冲浪运动": 14,
                "体育运动其他": 15,
                "其他涉水运动": 16,
                "滑板运动": 17,
                "格斗类运动": 18,
                "体操类运动": 19,
                "极限运动": 20,
                "户外运动": 21,
                "射击类运动": 22,
                "NBA": 23,
                "CBA": 24
            }
        },
        "医疗": {
            "label": 8,
            "sub_topic":{
                "养生茶饮": 0,
                "食补养生": 1,
                "保健品": 2,
                "中医疗养": 3,
                "冥想禅修": 4,
                "宫颈癌疫苗": 5,
                "疫苗": 6,
                "体检": 7,
                "职场亚健康": 8,
                "儿科疾病": 9,
                "感冒发烧": 10,
                "呼吸道疾病": 11,
                "糖尿病": 12,
                "心脑血管疾病": 13,
                "女性健康": 14,
                "心理健康": 15,
                "牙齿健康": 16,
                "脾胃肝胆健康": 17,
                "内分泌健康": 18,
                "肛肠/泌尿健康": 19,
                "眼部健康": 20,
                "耳鼻喉健康": 21,
                "骨骼肌肉健康": 22,
                "皮肤健康": 23,
                "急救知识": 24,
                "健康科普": 25,
                "中医药材": 26,
                "两性健康": 27,
                "疾病诊疗": 28,
                "就诊经验": 29,
                "医疗其他": 30
            }
        },
        "家居家装": {
            "label": 9,
            "sub_topic":{
                "生活服务": 0, 
                "装修改造": 1, 
                "装修设计": 2, 
                "景观设计": 3, 
                "卫浴家装": 4, 
                "家装材料": 5, 
                "家装干货": 6, 
                "厨房大家电": 7,  
                "厨房小家电": 8, 
                "家居灯饰": 9, 
                "智能家居": 10, 
                "传统家电": 11, 
                "儿童家具": 12, 
                "卧室家具": 13, 
                "客厅家具": 14, 
                "餐厅家具": 15, 
                "家具测评互动": 16, 
                "字画装饰": 17, 
                "布艺家纺": 18, 
                "家居饰品摆件": 19, 
                "商业装修设计": 20, 
                "餐具厨具": 21, 
                "绿植盆景": 22, 
                "插花装饰": 23, 
                "家居好物": 24,
                "家居家装其他": 25
            }
        },
        "职场": {
            "label": 10,
            "sub_topic":{
                "求职分享": 0, 
                "职场分享": 1, 
                "招聘分享": 2, 
                "职场软实力": 3, 
                "职场专业力": 4, 
                "健康管理考试": 5, 
                "职场资讯": 6, 
                "财会类考试": 7, 
                "教资类考试": 8, 
                "建筑类考试": 9, 
                "医护类考试": 10, 
                "金融类考试": 11, 
                "法律类考试": 12, 
                "计算机类考试": 13, 
                "灵活就业/创业": 14,
                "职业其他": 15
            }
        },
        "教育": {
            "label": 11,
            "sub_topic":{
                "学前教育": 0,
                "幼升小": 1,
                "小学课业": 2,
                "小升初": 3,
                "初中课业": 4,
                "专科教育": 5,
                "中考升学": 6,
                "高中课业": 7,
                "高考升学": 8,
                "大学课业": 9,
                "大学考试": 10,
                "毕业论文": 11,
                "研究生教育": 12,
                "考研经历": 13,
                "成人自考": 14,
                "海外教育": 15,
                "公务员考试": 16,
                "事业编考试": 17,
                "英语提升": 18,
                "普通话学习": 19,
                "小语种学习": 20,
                "艺考": 21,
                "课外辅导": 22,
                "教育资讯": 23,
                "教育其他": 24
            }
        },
        "出行": {
            "label": 12,
            "sub_topic":{
                "公园": 0,
                "人文景观": 1,
                "自然景观": 2,
                "风土人情": 3,
                "综合出游": 4,
                "艺术展": 5,
                "文物文化展": 6,
                "时尚展": 7,
                "代步工具": 8,
                "其他展会": 9,
                "酒店": 10,
                "商超": 11,
                "游乐园": 12,
                "养生场所": 13,
                "线下密室": 14,
                "线下休闲活动": 15,
                "露营": 16,
                "出行其他": 17
            }
        },
        "母婴": {
            "label": 13,
            "sub_topic":{
                "备孕": 0,
                "孕期身材管理": 1,
                "孕期穿搭": 2,
                "孕期日常": 3,
                "孕产经验": 4,
                "孕产好物推荐": 5,
                "孕产心理": 6,
                "孕产健康": 7,
                "月子餐": 8,
                "育儿嫂": 9,
                "母婴日常": 10,
                "全职妈妈": 11,
                "二胎妈妈": 12,
                "宝妈日常": 13,
                "婴童健康": 14,
                "婴童着装": 15,
                "婴童玩具": 16,
                "婴童心理": 17,
                "早教启蒙": 18,
                "婴童洗护": 19,
                "婴童用品": 20,
                "婴童饮食": 21,
                "育儿经验": 22,
                "兴趣培养": 23,
                "育儿政策": 24,
                "产后恢复": 25,
                "母婴其他": 26
            }
        },
        "艺术": {
            "label": 14,
            "sub_topic":{
                "歌剧": 0,
                "戏剧": 1,
                "传统戏曲": 2,
                "音乐剧": 3,
                "艺术作品鉴赏": 4,
                "艺术知识普及": 5,
                "国画展示": 6, 
                "油画展示": 7,
                "水彩画展示": 8,
                "马克笔画展示": 9,
                "彩铅画展示": 10,
                "油画棒绘画展示": 11,
                "素描速写展示": 12,
                "插画展示": 13,
                "软件绘画展示": 14,
                "艺术创作展示": 15,
                "绘画干货": 16,
                "雕塑展示": 17,
                "艺术品交易": 18,
                "数字艺术": 19,
                "装置艺术": 20,
                "涂鸦艺术": 21, 
                "舞蹈剧": 22, 
                "绘画工具流通": 23, 
                "广告创意": 24, 
                "商业设计": 25,
                "艺术其他": 26
            }
        },
        "音乐": {
            "label": 15,
            "sub_topic":{
                "音乐制作": 0,
                "吉他教学": 1,
                "钢琴教学": 2,
                "乐器教学": 3,
                "乐器制作": 4,
                "音乐学习": 5,
                "吉他演奏": 6,
                "钢琴演奏": 7,
                "乐器演奏": 8,
                "演唱翻唱": 9,
                "吉他": 10,
                "钢琴": 11,
                "乐器展示": 12,
                "音乐现场": 13,
                "民乐": 14,
                "声乐": 15
            }
        },
        "摄影": {
            "label": 16,
            "sub_topic":{
                "家庭写真": 0, 
                "证件照": 1, 
                "情侣写真": 2, 
                "个人写真": 3, 
                "时尚街拍": 4, 
                "人文摄影": 5, 
                "城市摄影": 6, 
                "自然摄影": 7, 
                "动物摄影": 8, 
                "随拍": 9, 
                "后期修图": 10, 
                "摄影教程": 11, 
                "视频制作": 12, 
                "其他写真": 13, 
                "商业摄影": 14,
                "静物摄影": 15,
                "摄影商业活动": 16,
                "摄影其他": 17
            }
        },
        "影视": {
            "label": 17,
            "sub_topic":{
                "影视混剪": 0, 
                "国产古装剧分享": 1, 
                "国产现代剧分享": 2, 
                "日剧分享": 3, 
                "韩剧分享": 4, 
                "欧美剧分享": 5, 
                "剧集分享": 6, 
                "剧集互动": 7, 
                "欧美电影分享": 8, 
                "华语电影分享": 9, 
                "日韩电影分享": 10, 
                "电影分享": 11, 
                "电影互动": 12, 
                "广播剧": 13, 
                "自制短剧": 14, 
                "生活小剧场": 15,
                "影视同人创作": 16, 
                "影视周边": 17, 
                "纪录片分享": 18, 
                "纪录片互动": 19
            }
        },
        "兴趣爱好": {
            "label": 18,
            "sub_topic":{
                "创意手作": 0,
                "手工摆件": 1,
                "手工饰品": 2,
                "手工编织": 3,
                "缝纫布艺": 4,
                "文具手账": 5,
                "纸艺": 6,
                "陶艺": 7,
                "文玩": 8,
                "标本": 9,
                "手工皮具": 10, 
                "手工生活用品": 11, 
                "科技爱好": 12, 
                "收集爱好": 13, 
                "晶石藏品": 14, 
                "解压视频": 15, 
                "低龄内容": 16,
                "兴趣爱好其他": 17
            }
        },
        "宠物": {
            "label": 19,
            "sub_topic":{
                "猫日常": 0,
                "猫养护": 1,
                "狗日常": 2,
                "狗养护": 3,
                "啮齿类": 4,
                "宠物其他": 5,
                "兔类日常": 6,
                "兔类养护": 7,
                "鸟类": 8,
                "爬宠": 9,
                "水族类": 10,
                "异宠": 11
            }
        },
        "商业财经": {
            "label": 20,
            "sub_topic":{
                "社会保险": 0,
                "人身保险": 1,
                "存钱记账": 2,
                "保险": 3,
                "贷款交易": 4,
                "房产交易": 5,
                "基金理财": 6,
                "股票交易": 7,
                "投资理财": 8,
                "财经解读": 9,
                "商业财经其他": 10
            }
        },
        "娱乐": {
            "label": 21,
            "sub_topic":{
                "音乐分享": 0,
                "舞蹈表演": 1,
                "舞蹈教学": 2,
                "奇闻异事": 3,
                "韩国综艺": 4,
                "语言节目": 5,
                "生活类综艺": 6,
                "竞技类综艺": 7,
                "选秀类综艺": 8,
                "婚恋类综艺": 9,
                "表演类综艺": 10,
                "益智类综艺": 11,
                "其他综艺": 12,
                "文旅探索综艺": 13, 
                "趣味艺能综艺": 14, 
            }
        },
        "人文": {
            "label": 22,
            "sub_topic":{
                "硬笔书法": 0, 
                "毛笔书法": 1, 
                "网文创作技巧": 2, 
                "女频网文分享": 3, 
                "网文阅读推荐": 4, 
                "书籍阅读推荐": 5, 
                "阅读资源流通": 6, 
                "读书日常": 7, 
                "古董文物": 8, 
                "传统文化习俗": 9, 
                "写作交流分享": 10, 
                "文学资讯": 11, 
                "汉语言文化": 12, 
                "文创周边": 13
            }
        },
        "婚嫁": {
            "label": 23,
            "sub_topic":{
                "求婚": 0, 
                "婚纱照": 1, 
                "备婚": 2, 
                "订婚": 3, 
                "婚礼纪实": 4, 
                "婚礼服饰": 5,
                "婚礼妆容": 6,
                "婚嫁其他": 7
            }
        },
        "情感": {
            "label": 24,
            "sub_topic":{
                "爱情": 0, 
                "友情": 1, 
                "亲情": 2, 
                "女性心理": 3, 
                "心灵鸡汤": 4,
                "性格分析": 5
            }
        },
        "玩具": {
            "label": 25,
            "sub_topic":{
                "手办雕塑": 0, 
                "微缩模型": 1, 
                "益智玩具": 2, 
                "玩偶": 3, 
                "乐高": 4,
                "玩具其他": 5
            }
        },
        "素材": {
            "label": 26,
            "sub_topic":{
                "壁纸分享互动": 0, 
                "头像分享互动": 1, 
                "表情包分享互动": 2, 
                "文案分享互动": 3, 
                "设计素材分享互动": 4
            }
        },
        "二次元": {
            "label": 27,
            "sub_topic":{
                "日漫分享互动": 0, 
                "国漫分享互动": 1, 
                "动漫分享互动": 2, 
                "cos展示互动": 3, 
                "动漫同人创作": 4, 
                "动漫周边展示": 5, 
                "动漫周边流通": 6, 
                "漫展活动分享": 7, 
                "二次元同好互动": 8,
                "自设oc": 9
            }
        },
        "资讯": {
            "label": 28,
            "sub_topic":{
                "移民资讯": 0, 
                "落户资讯": 1, 
                "民生资讯": 2, 
                "时政资讯": 3,
                "新闻报道": 4
            }
        },
        "星座命理": {
            "label": 29,
            "sub_topic":{
                "星座运势": 0, 
                "传统命理": 1, 
                "西式占卜": 2,
                "星座命理其他": 3
            }
        },
        "社科": {
            "label": 30,
            "sub_topic":{
                "法律知识": 0, 
                "历史知识": 1, 
                "科学科普": 2,
                "地理知识": 3,
                "工业机械": 4,
                "军事知识": 5
            }
        },
        "萌娃": {
            "label": 31,
            "sub_topic":{
                "萌娃日常": 0, 
                "萌娃影像": 1, 
                "萌娃舞蹈": 2, 
                "萌娃才艺": 3
            }
        },
        "潮流": {
            "label": 32,
            "sub_topic":{
                "盲盒玩具展示": 0, 
                "盲盒玩具流通": 1, 
                "潮流活动": 2
            }
        },
        "搞笑": {
            "label": 33,
            "sub_topic":{
                "搞笑段子分享": 0
            }
        },
        "时尚": {
            "label": 34,
            "sub_topic":{
                "服装设计": 0, 
                "服饰购买攻略": 1, 
                "服饰定制": 2, 
                "奢侈品交易互动": 3, 
                "服饰箱包交易互动": 4, 
                "居家服装": 5, 
                "箱包分享": 6, 
                "礼服分享": 7, 
                "运动装": 8, 
                "通勤服装": 9, 
                "通勤包分享": 10, 
                "时装秀/秀场": 11, 
                "日常穿搭": 12, 
                "奢侈品箱包": 13, 
                "奢侈品首饰": 14, 
                "高端表": 15, 
                "奢侈品服饰": 16, 
                "奢侈品": 17, 
                "发型工具产品": 18, 
                "发饰分享": 19, 
                "首饰分享": 20, 
                "手表分享": 21, 
                "墨镜分享": 22, 
                "眼镜/镜框分享": 23, 
                "腰带分享": 24, 
                "丝巾分享": 25, 
                "围巾分享": 26, 
                "烫染造型": 27, 
                "服装配饰分享": 28, 
                "男士穿搭": 29, 
                "胖女孩穿搭": 30, 
                "高个女生穿搭": 31, 
                "小个女生穿搭": 32, 
                "梨形身材穿搭": 33, 
                "中老年妈妈装": 34, 
                "明星同款": 35, 
                "古着": 36, 
                "jk制服": 37, 
                "lolita": 38, 
                "汉服": 39, 
                "穿搭风格": 40, 
                "衬衫分享": 41, 
                "外套分享": 42, 
                "羽绒服分享": 43, 
                "上衣分享": 44, 
                "裙子分享": 45, 
                "旗袍分享": 46, 
                "裤子分享": 47, 
                "袜子分享": 48, 
                "内衣分享": 49, 
                "理发": 50, 
                "快销品牌": 51, 
                "帽子分享": 52, 
                "泳装": 53, 
                "书包分享": 54, 
                "单肩包分享": 55, 
                "箱包挂饰分享": 56, 
                "钱包分享": 57, 
                "高跟鞋分享": 58, 
                "拖鞋分享": 59, 
                "凉鞋分享": 60, 
                "靴子分享": 61, 
                "运动鞋分享": 62, 
                "皮鞋分享": 63, 
                "休闲鞋分享": 64, 
                "人体穿刺": 65, 
                "纹身": 66, 
                "儿童发型": 67, 
                "男士发型": 68, 
                "女士短发": 69, 
                "刘海造型": 70, 
                "编发造型": 71,
                "时尚其他": 72
            }
        },
        "美妆": {
            "label": 35,
            "sub_topic":{
                "男士护理": 0, 
                "面膜分享": 1, 
                "眼霜分享": 2, 
                "面霜分享": 3, 
                "颈霜分享": 4, 
                "身体乳分享": 5, 
                "水乳精华分享": 6, 
                "护肤品交易互动": 7, 
                "防晒": 8, 
                "祛斑祛痘": 9, 
                "抗老": 10, 
                "美白": 11, 
                "洁面": 12, 
                "唇部护理": 13, 
                "眼部护理": 14, 
                "护肤": 15, 
                "足部护理": 16, 
                "口腔护理": 17, 
                "脱毛": 18, 
                "沐浴清洁": 19, 
                "洗手护手": 20, 
                "生发防脱": 21, 
                "女性用品": 22, 
                "眼妆产品分享": 23, 
                "唇妆产品分享": 24, 
                "修容腮红分享": 25, 
                "遮瑕产品分享": 26, 
                "底妆产品分享": 27, 
                "定妆产品分享": 28, 
                "卸妆产品分享": 29, 
                "化妆工具分享": 30, 
                "彩妆交易互动": 31, 
                "妆容展示": 32, 
                "化妆教程": 33, 
                "彩妆": 34, 
                "香水香膏": 35, 
                "眼部医美": 36, 
                "牙齿医美": 37, 
                "面部轮廓医美": 38, 
                "鼻部医美": 39, 
                "唇部医美": 40, 
                "医美护肤": 41, 
                "医美整形": 42, 
                "家用美容仪": 43, 
                "美睫纹绣": 44, 
                "美甲": 45,
                "洗护工具": 46, 
                "美瞳": 47,
                "美妆其他": 48
            }
        },
    }

#print(label_map)
#print(label_map.keys())
topic_map={}
sub_topic_map={}
for key in label_map.keys():
    topic_num = label_map[key]['label']
    topic_map[topic_num] = key
    sub_topic_map[topic_num] = {}
    for sub_key in label_map[key]['sub_topic'].keys():
        sub_num = label_map[key]['sub_topic'][sub_key]
        sub_topic_map[topic_num][sub_num] = sub_key

all_topics = []
all_sub_topics = []
for key in label_map.keys():
    all_topics.append(key)
    for sub_key in label_map[key]['sub_topic'].keys():
        all_sub_topics.append(sub_key)