addpath('src');

figure('position',[100 100 780 1200]);
t=tiledlayout(1,1);
t.TileSpacing = 'compact';
t.Padding = 'compact';

DNAseqLength = 10;
MutationRate = 0.001;
n=60;
Deco_weight=[1/8,1/8,4/8,2/8];
Deco = randsample(4,n,true,Deco_weight);

UniPerm = rand(n,1);
[~,Perm] = sort(UniPerm); 
[Parent,x,y,n,Child] = generate_deterministic_permutree(Perm',Deco,n);


SplitLocation = floor( (DNAseqLength-4) * rand(length(x),1) ) + 2;
max_y_index = find(y==max(y));
hiddenDNAseq = zeros(length(x), DNAseqLength);

for ii=1:length(max_y_index)
    hiddenDNAseq(max_y_index(ii),:)...
        = randsample('ACGT',size(hiddenDNAseq,2),true,[0.25 0.25 0.25 0.25]);
end

for ii=1:size(Child,2)
    if size(Child{ii},1)==2
        if x(Child{ii}(1)) > x(Child{ii}(2))
            Child{ii} = [Child{ii}(2);Child{ii}(1)];
        end
    end
end
for ii=1:length(y)
    if size(Parent{ii},1)==2
        if x(Parent{ii}(1)) > x(Parent{ii}(2))
            Parent{ii} = [Parent{ii}(2);Parent{ii}(1)];
        end
    end
end
originalParent = Parent;
originalChild = Child;

for ii=size(Deco,1):-1:1
    if Deco(ii)==2
        Parent{Child{ii}(1)}(Parent{Child{ii}(1)}==ii) = Parent{ii}(1);
        Parent{Child{ii}(2)}(Parent{Child{ii}(2)}==ii) = Parent{ii}(2);
        Child{Parent{ii}(1)}(Child{Parent{ii}(1)}==ii) = Child{ii}(1);
        Child{Parent{ii}(2)}(Child{Parent{ii}(2)}==ii) = Child{ii}(2);
        Parent{ii}=[];
        Child{ii}=[];
    end
end

for ii=size(Deco,1):-1:1
    switch Deco(ii)
        case 1
            hiddenDNAseq(ii,:) = hiddenDNAseq(Child{ii}(1),:);
        case 3
            hiddenDNAseq(ii,:) = hiddenDNAseq(Child{ii}(1),:);
            hiddenDNAseq(ii,:) = MutationOperation(hiddenDNAseq(ii,:),...
                abs(y(ii)-y(Child{ii}(1))),MutationRate);
        case 4
            sl = SplitLocation(ii);
            hiddenDNAseq(ii,1:sl) = hiddenDNAseq(Child{ii}(1),1:sl);
            hiddenDNAseq(ii,sl+1:end) = hiddenDNAseq(Child{ii}(2),sl+1:end);
            hiddenDNAseq(ii,1:sl) = MutationOperation(hiddenDNAseq(ii,1:sl),...
                abs(y(ii)-y(Child{ii}(1))),MutationRate);
            hiddenDNAseq(ii,sl+1:end) = MutationOperation(hiddenDNAseq(ii,sl+1:end),...
                abs(y(ii)-y(Child{ii}(2))),MutationRate);
    end
end

nexttile
G = plot_DNAseqTree(Parent,x,y,n, Deco, hiddenDNAseq);
daspect([1 1 1]);
