function seq = MutationOperation(seq, timeEvo, MutationRate)

MutationProb = 0.25 * (1-exp(-4*MutationRate*timeEvo));
SelfProb = 0.25 * (1+ 3*exp(-4*MutationRate*timeEvo));


for ii=1:length(seq)
    switch seq(ii)
        case 'A'
            weight = [SelfProb MutationProb MutationProb MutationProb];
        case 'C'
            weight = [MutationProb SelfProb MutationProb MutationProb];
        case 'G'
            weight = [MutationProb MutationProb SelfProb MutationProb];
        otherwise
            weight = [MutationProb MutationProb MutationProb SelfProb];
    end
    seq(ii) = randsample('ACGT',1,true,weight);
end

