function [Parent,x,y,n] = generate_random_permutree(n,Deco_weight)

%1: (|) 1 child, 1 parent
%2: (X) 2 children, 2 parents
%3: (/|)1 child, 2 paretns
%4: (|/)2 children, 1 parent

%n=50;
Perm = randperm(n);
%Deco = randsample(4,n,true,[1/4,1/4,1/4,1/4]);
%Deco = randsample(4,n,true,[0,0,0,1]);
Deco = randsample(4,n,true,Deco_weight);
Threshold = zeros(n,1);
Threshold(Perm(Deco==2))=1;
Threshold(Perm(Deco==3))=1;
List_Threshold = find(Threshold==1);
List_Threshold = [0;List_Threshold;n+1];

VertexSet = [];
for ii=1:length(List_Threshold)-1
    VertexSet = [VertexSet;[(List_Threshold(ii)+List_Threshold(ii+1))/2, 0]];
end
CurrentVertices = (n+1):(n+length(VertexSet));
x = [Perm, VertexSet(:,1)'];
y = [1:length(Perm), zeros(1,length(VertexSet(:,1)))];

for ii=1:(n+length(VertexSet))
    Parent{ii}=[];
    Child{ii}=[];
end

for jj=1:n
    temp = Perm(jj);
    switch Deco(jj)
        case 1
            Part = which_partition(List_Threshold, temp);
            Child{CurrentVertices(Part)} = [Child{CurrentVertices(Part)};jj];
            Parent{jj} = CurrentVertices(Part);
            CurrentVertices(Part) = jj;
        case 2
            Part = which_partition(List_Threshold, temp);
            Child{CurrentVertices(Part)} = [Child{CurrentVertices(Part)};jj];
            Child{CurrentVertices(Part+1)} = [Child{CurrentVertices(Part+1)};jj];
            Parent{jj} = [CurrentVertices(Part);CurrentVertices(Part+1)];
            CurrentVertices(Part) = jj;
            CurrentVertices(Part+1) = jj;
        case 3
            Part = which_partition(List_Threshold, temp);
            Child{CurrentVertices(Part)} = [Child{CurrentVertices(Part)};jj];
            Child{CurrentVertices(Part+1)} = [Child{CurrentVertices(Part+1)};jj];
            Parent{jj} = [CurrentVertices(Part);CurrentVertices(Part+1)];
            CurrentVertices(Part) = jj;
            CurrentVertices(Part+1) = [];
            List_Threshold(Part+1) = [];
        otherwise
            Part = which_partition(List_Threshold, temp);
            Child{CurrentVertices(Part)} = [Child{CurrentVertices(Part)};jj];
            Parent{jj} = CurrentVertices(Part);
            CurrentVertices(Part) = jj;
            CurrentVertices = [CurrentVertices(1:Part) jj CurrentVertices(Part+1:end)];
%             size(List_Threshold(1:Part))
%             size(temp)
%             size(List_Threshold(Part+1:end))
            List_Threshold = [List_Threshold(1:Part);temp;List_Threshold(Part+1:end)];
    end
    
end


TopThreshold = zeros(n,1);
TopThreshold(Perm(Deco==2))=1;
TopThreshold(Perm(Deco==4))=1;
Top_List_Threshold = find(TopThreshold==1);
Top_List_Threshold = [0;Top_List_Threshold;n+1];
TopVertexSet = [];
for ii=1:length(Top_List_Threshold)-1
    TopVertexSet = [TopVertexSet;[(Top_List_Threshold(ii)+Top_List_Threshold(ii+1))/2, 0]];
end
nn=size(x,2);
for ii=1:size(TopVertexSet,1)
    Parent{nn+ii}=CurrentVertices(ii);
    Child{CurrentVertices(ii)}=[Child{CurrentVertices(ii)};nn+ii];
end
x = [x, TopVertexSet(:,1)'];
y = [y, (n+1)*ones(1,size(TopVertexSet,1))];

