function log_prob = JClikelihood(hiddenDNAseq, Parent, Child, x, y, MutationRate, SplitLocation)

for ii=1:size(Child,2)
    if size(Child{ii},1)==2
        if x(Child{ii}(1)) > x(Child{ii}(2))
            Child{ii} = [Child{ii}(2);Child{ii}(1)];
        end
    end
end
for ii=1:length(y)
    if size(Parent{ii},1)==2
        if x(Parent{ii}(1)) > x(Parent{ii}(2))
            Parent{ii} = [Parent{ii}(2);Parent{ii}(1)];
        end
    end
end
originalParent = Parent;
originalChild = Child;
for ii=size(Deco,1):-1:1
    if Deco(ii)==2
        Parent{Child{ii}(1)}(Parent{Child{ii}(1)}==ii) = Parent{ii}(1);
        Parent{Child{ii}(2)}(Parent{Child{ii}(2)}==ii) = Parent{ii}(2);
        Child{Parent{ii}(1)}(Child{Parent{ii}(1)}==ii) = Child{ii}(1);
        Child{Parent{ii}(2)}(Child{Parent{ii}(2)}==ii) = Child{ii}(2);
        Parent{ii}=[];
        Child{ii}=[];
    end
end

for ii=size(Deco,1):-1:1
    switch Deco(ii)
%         case 1
%             hiddenDNAseq(ii,:) = hiddenDNAseq(Child{ii}(1),:);
        case 3
            timeEvo = abs(y(ii)-y(Child{ii}(1)));
            log_prob = log_prob...
                + branch_prob(hiddenDNAseq(ii,:),...
                hiddenDNAseq(Child{ii}(1),:), timeEvo, MutationRate);
        case 4
            sl = SplitLocation(ii);
            timeEvo = abs(y(ii)-y(Child{ii}(1)));
            log_prob = log_prob + branch_prob(hiddenDNAseq(ii,1:sl),...
                hiddenDNAseq(Child{ii}(1),1:sl),timeEvo, MutationRate);
            timeEvo = abs(y(ii)-y(Child{ii}(2)));
            log_prob = log_prob + branch_prob(hiddenDNAseq(ii,sl+1:end),...
                hiddenDNAseq(ii,sl+1:end),timeEvo, MutationRate);
    end
end




function log_prob = branch_prob(A, B, timeEvo, MutationRate)

temp = sum(A==B);
temptemp = length(A) - temp;
log_prob = (-1)*(temp+temptemp)*log(4) + temp*log(1-exp(-4*MutationRate*timeEvo))...
    + temptemp * log(1+3*exp(-4*MutationRate*timeEvo));



