# Code for ICLR 2026 Submission: "Incentive-aligned LLM Summaries"

This folder contains the source code for the ICLR 2026 submission titled "Incentive-aligned LLM Summaries". The code allows for the replication of the experiments and results presented in the paper.

---

## Code Structure

The code is provided as Jupyter Notebooks (`.ipynb` files), which can be run in any environment that supports them (e.g., Google Colab, VS Code, a local Jupyter server). For the camera-ready version, we plan to provide standalone Python (`.py`) scripts for easier execution and host it publically in github.

---

## Prerequisites: Configuring the LLM API

The core logic of our method relies on calls to a large language model (LLM). The provided code includes a self-contained function for making these API calls. To run the notebooks, you will need to configure this function to use your own LLM API provider and credentials.

**Instructions:**

1.  **Locate the API Function**: In the notebooks, find the function gemini_call_sync responsible for making calls to the LLM API. 
2.  **Modify the Function**: Replace the logic inside this function with the client initialization and API call for your chosen LLM provider (e.g., Gemini, OpenAI, Anthropic, open-sourced models, or any other compatible endpoint).
3.  **Add Credentials**: Ensure you provide your API key and any other required credentials (e.g., project ID and api_key).

The function signature should be preserved to ensure compatibility with the rest of the code. As long as it accepts the necessary inputs (like the prompt) and returns the model's text generation, any backend can be used.

Specifically, our experimental result 1 can be obtained by running clash_cleaned.ipynb and nq_cleaned.ipynb, and result 2 can be obtained by running uninformative_cleaned.ipynb.