#!/usr/bin/env python3

import subprocess

repos = ["pypa/setuptools", "psf/requests", "certifi/python-certifi", "kjd/idna", "jawah/charset_normalizer", "pypa/packaging", "dateutil/dateutil", "boto/s3transfer", "yaml/pyyaml", "benjaminp/six", "fsspec/filesystem_spec", "fsspec/s3fs", "numpy/numpy", "pypa/wheel", "pypa/pip", "pyca/cryptography", "aws/aws-cli", "pydantic/pydantic", "python-cffi/cffi", "eliben/pycparser", "python/importlib_metadata", "jmespath/jmespath.py", "pallets/click", "jaraco/zipp", "pyasn1/pyasn1", "pallets/markupsafe", "tartley/colorama", "tox-dev/platformdirs", "pallets/jinja", "Textualize/rich", "hukkin/tomli", "pytest-dev/pytest", "pydantic/pydantic-core", "jpadilla/pyjwt", "pytest-dev/pluggy", "pypa/virtualenv", "python-jsonschema/jsonschema", "googleapis/python-api-common-protos", "tkem/cachetools", "googleapis/google-auth-library-python", "tox-dev/py-filelock", "GrahamDumpleton/wrapt", "pyasn1/pyasn1-modules", "python-greenlet/greenlet", "pytest-dev/iniconfig", "pygments/pygments", "annotated-types/annotated-types", "aio-libs/yarl", "requests/requests-oauthlib", "python/tzdata", "giampaolo/psutil", "aio-libs/multidict", "pyparsing/pyparsing", "requests/toolbelt", "agronholm/exceptiongroup", "pallets/werkzeug", "facelessuser/soupsieve", "oauthlib/oauthlib", "aio-libs/frozenlist", "more-itertools/more-itertools", "pypa/distlib", "sdispater/tomlkit", "cpburnz/python-pathspec", "aio-libs/aiosignal", "grpc/grpc", "https:/tqdm.github.io", "scipy/scipy", "aio-libs/async-timeout", "python-pillow/Pillow", "gweis/isodate", "agronholm/anyio", "micheles/decorator", "executablebooks/markdown-it-py", "laurent-laporte-pro/deprecated", "python/mypy_extensions", "python-trio/sniffio", "encode/httpx", "nedbat/coveragepy", "pallets/flask", "crate-py/rpds", "pyca/pyopenssl", "python-hyper/h11", "executablebooks/mdurl", "encode/httpcore", "lxml/lxml", "python-jsonschema/jsonschema-specifications", "googleapis/proto-plus-python.git", "theskumar/python-dotenv", "uqfoundation/dill", "aio-libs/propcache", "python-jsonschema/referencing", "python-poetry/poetry-core", "googleapis/python-storage", "pexpect/ptyprocess", "gitpython-developers/GitPython", "core/azure-core", "pexpect/pexpect", "wbond/asn1crypto", "aio-libs/aiohappyeyeballs", "pyca/pynacl", "jd/tenacity", "pallets/itsdangerous", "websocket-client/websocket-client.git", "main/opentelemetry-sdk", "django/asgiref", "googleapis/python-cloud-core", "gitpython-developers/gitdb", "gitpython-developers/smmap", "python/importlib_resources", "psycopg/psycopg2", "AzureAD/microsoft-authentication-library-for-python", "sqlalchemy/alembic", "jaraco/keyring", "pycqa/mccabe", "scikit-learn/scikit-learn", "pypa/trove-classifiers", "googleapis/google-resumable-media-python", "jquast/wcwidth", "chardet/chardet", "python/grpcio_tools", "mrabarnett/mrab-regex", "sarugaku/shellingham", "main/opentelemetry-api", "pallets-eco/blinker", "pytest-dev/pytest-cov", "jaraco/jaraco.classes", "pyca/bcrypt", "pypa/build", "litl/backoff", "snowflakedb/snowflake-connector-python", "fastapi/fastapi", "pypa/pyproject-hooks", "mitya57/secretstorage", "testing-cabal/mock", "astanin/python-tabulate", "googleapis/python-crc32c", "matplotlib/matplotlib", "benoitc/gunicorn", "horejsek/python-fastjsonschema", "paramiko/paramiko", "networkx/networkx", "joblib/threadpoolctl", "googleapis/google-api-python-client", "andialbrecht/sqlparse", "pycqa.github.io/isort", "marshmallow-code/marshmallow", "googleapis/python-bigquery", "storage/azure-storage-blob", "prompt-toolkit/python-prompt-toolkit", "joblib/joblib", "identity/azure-identity", "nucleic/kiwi", "docker/docker-py", "redis/redis-py", "ipython/ipython", "martinblech/xmltodict", "termcolor/termcolor", "GoogleCloudPlatform/google-auth-library-python-oauthlib", "encode/starlette", "cloudpipe/cloudpickle", "fonttools/fonttools", "python-babel/babel", "erdewit/nest_asyncio", "cython/cython", "ekalinin/nodeenv", "tiran/defusedxml", "PyCQA/pyflakes", "getsentry/sentry-python", "regebro/tzlocal", "python/typeshed", "main/opentelemetry-semantic-conventions", "ipython/traitlets", "https:/Python-Markdown.github.io", "pycqa/flake8", "kislyuk/argcomplete", "tornadoweb/tornado", "psf/cachecontrol", "python-distro/distro", "GoogleCloudPlatform/google-auth-library-python-httplib2", "encode/uvicorn", "tobgu/pyrsistent", "davidhalter/jedi", "uiri/toml", "prometheus/client_python", "huggingface/huggingface_hub", "openai/openai-python", "davidhalter/parso", "zeromq/pyzmq", "microsoft/debugpy", "contourpy/contourpy", "kubernetes-client/python", "ipython/matplotlib-inline", "python-websockets/websockets", "sdispater/crashtest", "fastapi/typer", "SimonSapin/python-webencodings", "pytest-dev/pytest-mock", "ijl/orjson", "googleapis/python-grpc-google-iam-v1", "huggingface/transformers", "stefankoegl/python-json-pointer", "mongodb/mongo-python-driver", "tlocke/scramp", "python-poetry/cleo", "alexmojaki/stack_data", "Legrandin/pycryptodome", "sphinx-doc/sphinx", "gristlabs/asttokens", "Legrandin/pycryptodome", "zopefoundation/zope.interface", "alexmojaki/executing", "uqfoundation/multiprocess", "ilevkivskyi/typing_inspect", "pre-commit/pre-commit", "un33k/python-slugify", "nhairs.github.io/python-json-logger", "pre-commit/identify", "ipython/ipykernel", "arrow-py/arrow", "pylint-dev/astroid", "tedder/requests-aws4auth", "alexmojaki/pure_eval", "python/typeshed", "main/opentelemetry-proto", "jupyter/jupyter_core", "Delgan/loguru", "PythonCharmers/python-future", "jupyter/jupyter_client", "asottile/cfgv", "ionelmc/python-lazy-object-proxy", "pylint-dev/pylint", "sdispater/pytzdata", "borntyping/python-colorlog", "master/backend", "DataDog/datadogpy", "aws/amazon-redshift-python-driver", "getsentry/responses", "elastic/elasticsearch-py", "master/hypothesis-python", "pygithub/pygithub", "pydantic/pydantic-settings", "jupyterlab/jupyterlab", "naimetti/rfc3339-validator", "Azure/msrest-for-python", "piskvorky/smart_open", "pytest-dev/pytest-runner", "invl/retry", "Azure/azure-sdk-for-python", "dvarrazzo/py-setproctitle", "snowballstem/snowball", "ActiveState/appdirs", "ipython/comm", "huggingface/tokenizers", "exporter/opentelemetry-exporter-otlp-proto-grpc", "mozilla/bleach", "exporter/opentelemetry-exporter-otlp-proto-http", "tlocke/pg8000", "h2non/jsonpath-ng", "jupyter/nbclient", "packages/google-cloud-secret-manager", "apache/airflow", "googleapis/python-pubsub", "mysql/mysql-connector-python", "jupyter-server/jupyter_server", "jaraco/jaraco.functools", "stefankoegl/python-json-patch", "django/django", "Kozea/tinycss2"]

for repo in repos:
    print(f"Making mirror repo for {repo}")
    out_make = subprocess.run(
        f"./make_repo.sh {repo}",
        shell=True,
        stdout=subprocess.DEVNULL,
        stderr=subprocess.DEVNULL,
    )
    if out_make.returncode != 0:
        print(f"Error making mirror repo for {repo}")
    else:
        print(f"Success making mirror repo for {repo}")
