from hpbandster.core.base_config_generator import base_config_generator
import pandas as pd

import moxing as mox
mox.file.copy_parallel('s3://bucket-010/boxiong/HpBandSter-icml_2018/data/', '/cache/data/')
# oa_lhd = pd.read_csv('/home/ma-user/work/data/svm/svm_oa.csv', header=0).values.astype(float)-11

oa_lhd = pd.read_csv('/cache/data/paramnet/paramnet_oa.csv', header=0).values.astype(float)

class LHDSampling(base_config_generator):
    """
        class to implement random sampling from a ConfigSpace
    """

    def __init__(self, configspace, **kwargs):
        """

        Parameters:
        -----------

        configspace: ConfigSpace.ConfigurationSpace
            The configuration space to sample from. It contains the full
            specification of the Hyperparameters with their priors
        **kwargs:
            see  hyperband.config_generators.base.base_config_generator for additional arguments
        """

        super().__init__(**kwargs)
        self.configspace = configspace
        self.count = 0
        self.oa_lhd = oa_lhd
        
#         self.configspace = {}


    def get_config(self, budget):
        sample_dict = {}
        
#         for idx, parameter in enumerate(self.configspace.get_hyperparameters()):
#             pa_name = parameter.name
#             pa_value = self.oa_lhd[self.count][idx]
#             sample_dict[pa_name] = pa_value

        for idx, parameter in enumerate(self.configspace.get_hyperparameters()):
            pa_name = parameter.name
            lower, upper = parameter.lower, parameter.upper
            sample_dict[pa_name] = lower + self.oa_lhd[self.count][idx]*(upper-lower)

        self.count = self.count +1
        print(sample_dict)
        return (sample_dict, {})
