import os
os.system('pip install theano==0.8.2')
os.system('pip install scipy==1.2.0')
os.system('pip install lasagne')
os.system('ls /home/work/user-job-dir/')
os.system('pip install hyperopt')
os.system('cd /home/work/user-job-dir/HpBandSter-icml_2018/ && pip install .')
os.system('cd /home/work/user-job-dir/HpBandSter-icml_2018/HPOlib2-new_benchmarks/ && pip install .')
os.system('cd /home/work/user-job-dir/HpBandSter-icml_2018/sgmcmc-master/ && pip install .')
# os.system('ls ~/.')
os.system('mkdir -p ~/.hpolib/BostonHousing/')
os.system('cp /home/work/user-job-dir/HpBandSter-icml_2018/data/bnn/housing.data  ~/.hpolib/BostonHousing/')

import argparse

import numpy as np

from workers.bnn import BNNWorker as Worker
import util

import moxing as mox

# deactivate debug output for faster experiments
import logging
logging.basicConfig(level=logging.DEBUG)

###############################################################################
#                    Benchmark specific stuff
###############################################################################
parser = argparse.ArgumentParser(description='Run different optimizers to optimize BNNs on different datasets.', conflict_handler='resolve')
parser = util.standard_parser_args(parser)


# add benchmark specific arguments
parser.add_argument('--dataset', choices=['toyfunction', 'bostonhousing', 'proteinstructure', 'yearprediction'], help="name of the dataset used", default='bostonhousing')
parser.add_argument('--min_budget', type=int, help='Minimum number of MCMC steps used to draw samples for the BNN.', default=300)
parser.add_argument('--max_budget', type=int, help='Maximum number of MCMC steps used to draw samples for the BNN.', default=10000)

parser.add_argument('--save_file', type=str, help='safe file.', default='/cache/data/results')
parser.add_argument('--runs', type=int, help='safe file.', default=100)

# parser.add_argument('--data_url', type=str, default=None, help='s3 path of dataset')
# parser.add_argument('--train_url', type=str, default=None, help='s3 path of outputs')
# parser.add_argument('--batch_size', type=int, default=64, help='batch_size') 
# parser.add_argument('--init_method', type=str, default=None, help='master add

args, unparsed = parser.parse_known_args()

# this is a synthetic benchmark, so we will use the run_id to separate the independent runs
worker = Worker(dataset=args.dataset, measure_test_loss=False, run_id=args.run_id, max_budget=args.max_budget)

# directory where the results are stored
dest_dir = os.path.join(args.dest_dir, "BNNs", "%s"%(args.dataset))

# SMAC can be informed whether the objective is deterministic or not
smac_deterministic = True

# run experiment
result, result_dict = util.run_experiment(args, worker, dest_dir, smac_deterministic, store_all_runs=True)

import pickle

os.makedirs('/cache/data/results/', exist_ok=True)

with mox.file.File('s3://bucket-010/boxiong/HpBandSter-icml_2018/results/'+args.save_file, 'wb') as fh:
    pickle.dump(result_dict, fh)
print(result.get_all_runs())

# mox.file.copy_parallel('/cache/data/results/'+args.save_file, 's3://bucket-010/boxiong/HpBandSter-icml_2018/results/')

