import os

os.system('pip install tensorforce')
os.system('pip install gym')
os.system('pip install Pyro4')
os.system('pip install tensorforce==0.4.3 ')
os.system('pip install scipy==1.2.0')
os.system('pip install tensorflow-gpu==1.5')

os.system('cd /home/work/user-job-dir/HpBandSter-icml_2018/ && pip install .')
os.system('cd /home/work/user-job-dir/HpBandSter-icml_2018/HPOlib2-new_benchmarks/ && pip install .')
os.system('cd /home/work/user-job-dir/HpBandSter-icml_2018/sgmcmc-master/ && pip install .')

import argparse

import numpy as np
import moxing as mox


# catch missing dependencies here
try:
	import tensorforce
	import gym
except ImportError:
	raise ImportError("You need to install 'tensorforce' and the OpenAI 'gym' package for this benchmark!")
except:
	raise




from workers.cartpole import CartpoleReducedWorker as Worker
import util

# deactivate debug output for faster experiments
import logging
logging.basicConfig(level=logging.DEBUG)


################################################################################
#                    Benchmark specific stuff
################################################################################


parser = argparse.ArgumentParser(description='Run different optimizers on the CountingOnes problem.', conflict_handler='resolve')
parser = util.standard_parser_args(parser)


# add benchmark specific arguments
parser.add_argument('--min_budget', type=int, help='Minimum number of independent runs to estimate mean loss.', default=9)
parser.add_argument('--max_budget', type=int, help='Maximum number of independent runs to estimate mean loss.', default=9)
parser.add_argument('--num_iterations', type=int, help='number of Hyperband iterations performed.', default=16)
parser.add_argument('--save_file', type=str, help='safe file.', default='/cache/')
parser.add_argument('--method', type=str, help='randomsearch', default='randomsearch')
parser.add_argument('--runs', type=int, help='safe file.', default=100)

args, unparsed = parser.parse_known_args()

# this is a synthetic benchmark, so we will use the run_id to separate the independent runs
worker = Worker(measure_test_loss=False, run_id=args.run_id)

# directory where the results are stored
dest_dir = os.path.join(args.dest_dir, "cartpole")

# SMAC can be informed whether the objective is deterministic or not
smac_deterministic = True

# run experiment
result, result_dict = util.run_experiment(args, worker, dest_dir, smac_deterministic, store_all_runs=True)

import pickle

os.makedirs('/cache/data/results/', exist_ok=True)

with mox.file.File('s3://bucket-010/boxiong/HpBandSter-icml_2018/results/'+args.save_file, 'wb') as fh:
    pickle.dump(result_dict, fh)
print(result.get_all_runs())