
import argparse
import numpy
import ConfigSpace as CS

from hpbandster.core.worker import Worker

from hpolib.benchmarks.surrogates.svm import SurrogateSVM as surrogate
from .base_worker import BaseWorker

class SVMSurrogateWorker(BaseWorker):
    def __init__(self, surrogate_path=None, sleep=False, **kwargs):

        b = surrogate(path=surrogate_path)
        cs = surrogate.get_configuration_space()
#         cs = self.get_configuration_space()
        kwargs.update({'max_budget': 1.})
        kwargs.update({'budget_name': 'dataset_fraction'})
        super().__init__(benchmark=b, configspace=cs, **kwargs)
        self.sleep = sleep
        
#     @staticmethod
#     def get_configuration_space():
#         cs = CS.ConfigurationSpace()
#         cs.add_hyperparameter(CS.CategoricalHyperparameter(name='x0', choices=[-10.0,-9.0, -8.0,-7.0,-6.0,-5.0,-4.0,-3.0,-2.0,-1.0,0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0]))
#         cs.add_hyperparameter(CS.CategoricalHyperparameter(name='x1', choices=[-10.0,-9.0, -8.0,-7.0,-6.0,-5.0,-4.0,-3.0,-2.0,-1.0,0.0,1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0]))
#         return cs
    
    def tpe_configspace(self):

        from hyperopt import hp

        space = {
            'x0':  hp.quniform('x0', -10., 10., 1),
            'x1':  hp.quniform("x1",  -10., 10., 1),

        }
        return(space)
    
