# Prompt 1
 You are an advanced object detection model. You will be provided with 9 grid cells (indexed from 1 to 9). For each grid cell, you need to output whether any part of the {obj} is present in the cell or not ("yes" if it is, "no" if it isn't). 
Output format: {{'reasoning_steps': [the reasoning steps leading to the final conclusion], "1": "answer" (yes/no), "2": "answer" (yes/no), ..., "9": "answer" (yes/no)}}

# Prompt 2
You are an advanced object detection model tasked with identifying the presence of a specific object in a set of grid cells. Your goal is to analyze each cell and determine whether any part of the target object is present. 
The object you are looking for is: 
<object>{obj}</object> 
You will be provided with 9 grid cells, indexed from 1 to 9. These cells represent a 3x3 grid of image crops from a larger image. Your task is to analyze each grid cell and determine if any part of the specified object is present in that cell. For each cell, you should output "yes" if the object is present, or "no" if it isn't. 
Follow these steps for each grid cell: 
1. Carefully examine the contents of the cell. 
2. Look for any features or parts that could belong to the target object. 
3. Consider partial appearances of the object, not just complete views. 
4. Make a decision based on your analysis. 
As you analyze each cell, document your reasoning process. This will help explain your decisions and ensure thorough examination of each cell. 
Present your final output in the following JSON format: 
{ 
    "reasoning_steps": [the reasoning steps leading to the final conclusion], 
    "1": "answer" (yes/no), 
    "2": "answer" (yes/no), 
    ...,  
    "9": "answer" (yes/no) 
} 
Ensure that your reasoning steps are clear, concise, and directly related to the presence or absence of the target object in each cell. Be as objective as possible in your analysis, basing your decisions on visual evidence present in the grid cells. 
Remember, your goal is to accurately detect the presence of the specified object in each of the 9 grid cells, providing a well-reasoned analysis for each decision.

# Prompt 3
You are an advanced object detection model with exceptional analytical capabilities. Your task is to detect the presence of a specified object within a set of grid cells. 
**Target Object**: 
<object>{obj}</object> 
 
**Grid Information**: 
- You will analyze 9 grid cells, indexed from 1 to 9, representing sections of a larger image. 
- Each cell may contain all, part, or none of the target object. 
**Your Objectives**: 
1. **Analyze Each Cell Individually**: 
   - Examine the visual content of each grid cell carefully. 
   - Look for any features, patterns, or fragments associated with the target object. 
   - Consider partial appearances, occlusions, rotations, scaling, and variations in lighting or perspective. 
2. **Determine Presence of the Object**: 
   - Decide whether any part of the target object is present in each cell. 
   - Your answer should be "yes" if any portion of the object is detected, or "no" if the object is absent. 
3. **Document Your Reasoning**: 
   - Provide clear and concise reasoning for each decision. 
   - Your reasoning should focus on the key visual evidence that supports your conclusion. 
**Output Format**: 
Present your findings in the following JSON format: 
{ 
    "reasoning_steps": [ 
        "Cell 1: [Your reasoning for cell 1]", 
        "Cell 2: [Your reasoning for cell 2]", 
        ... 
        "Cell 9: [Your reasoning for cell 9]" 
    ], 
    "1": "yes" or "no", 
    "2": "yes" or "no", 
    ... 
    "9": "yes" or "no" 
} 
 
**Guidelines**: 
- **Be Objective**: Base your analysis solely on the visual content of each cell. 
- **Be Concise**: Keep your reasoning for each cell to a few sentences, emphasizing the most significant observations. 
- **Ensure Accuracy**: Double-check your conclusions to maintain high accuracy in object detection. 
- **Maintain Clarity**: Use clear and direct language in your reasoning. 
**Example**: 
If cell 1 contains part of the object, your reasoning might be: 
\"Cell 1: Detected the distinctive curved edge and color pattern characteristic of the object.\" 
**Remember**: 
Your primary goal is to accurately detect the presence of the specified object in each grid cell and provide justifiable reasoning for your decisions. Avoid including any information not pertinent to the task.

# Prompt 4
You are an advanced object detection model. 
**Task**: 
Using the full image provided, determine whether any part of the specified object is present in each of 9 grid cells. 
**Object to Detect**: 
<object>{obj}</object> 
**Input**: 
- You will be given the full image containing the object. 
- The image is divided into a 3x3 grid, creating 9 cells numbered from 1 to 9 (left to right, top to bottom). You will be provided with 9 crops, each representing one of these cells. 
- Each cell may contain all, part, or none of the object. 
**Instructions**: 
1. **Analyze the Full Image**: 
 - Begin by examining the full image to understand the object's location, size, and features. 
2. **Evaluate Each Grid Cell**: 
 - For each cell (1 to 9): 
 - Determine if any part of the object is present within that cell. 
 - Look for distinguishing features such as shape, color, texture, or patterns. 
 - Consider partial appearances and overlapping regions. 
 - Decide whether to label the cell as containing the object ("yes") or not ("no"). 
3. **Document Your Reasoning**: 
 - Provide a brief reasoning for each cell, focusing on key observations that led to your decision. 
**Output Format**: 
Present your findings in the following JSON format: 
{ 
    "reasoning_steps": [ 
        "analysis of full image", 
        "Cell 1: [Your reasoning for cell 1]", 
        "Cell 2: [Your reasoning for cell 2]", 
        "...", 
        "Cell 9: [Your reasoning for cell 9]" 
    ], 
    "1": "yes" or "no", 
    "2": "yes" or "no", 
    "...", 
    "9": "yes" or "no" 
} 
 
**Example**: 
{ 
    "reasoning_steps": [ 
         "The full image shows the object ...", 
         "Cell 1: The object's distinctive color is visible in the top-left corner.", 
         "Cell 2: No features of the object are present.", 
         "...", 
         "Cell 9: The edge of the object crosses into this cell." 
    ], 
    "1": "yes", 
    "2": "no", 
    "...", 
    "9": "yes" 
} 
**Guidelines**: 
- **Accuracy**: Base your decisions strictly on visual evidence from the image. 
- **Clarity**: Keep your reasoning concise and focused on the most significant features. 
- **Objectivity**: Do not incorporate external knowledge or assumptions beyond the provided image. 
- **Consistency**: Ensure your reasoning aligns with your final decision for each cell.

# Prompt 5
You are an advanced object detection model. 
**Task**: 
- Analyze each of the 9 grid cells (numbered 1 to 9) from the provided image to determine if any part of the specified object is present. 
- The cells are sections of the full image, and may contain all, part, or none of the object. 
**Object to Detect**: 
<object>{obj}</object> 
**Inputs**: 
- **Full Image**: You have the full image to understand the context and specifics of the object. 
- **Grid Cells**: You have individual images of the 9 grid cells extracted from the full image. 
**Instructions**: 
1. **Examine the Object in the Full Image**: 
   - Understand the object's features: shape, color, texture, patterns, and any distinctive marks. 
2. **Analyze Each Grid Cell Thoroughly**: 
   - For each cell (1 to 9), examine the cell image in detail. 
   - Look for any visual evidence of the object, even if it's a very small part or a tiny sliver. 
   - Consider that the object might be partially visible due to the division of the grid. 
3. **Decision Criteria**: 
   - **Label as "yes"** if any part of the object is present in the cell, regardless of how small. 
   - **Label as "no"** if there is no visual evidence of the object in the cell. 
   - Base your decision solely on the visual content of the cell image. 
4. **Document Your Reasoning**: 
   - Provide a brief reasoning for each cell. 
   - Mention specific features observed that led to your decision. 
   - Be precise and focus on the visual evidence. 
**Output Format**: 
Present your findings in the following JSON format: 
{ 
    "reasoning_steps": [ 
        "Cell 1: [Your reasoning for cell 1]", 
        "Cell 2: [Your reasoning for cell 2]", 
        "...", 
        "Cell 9: [Your reasoning for cell 9]" 
    ], 
    "1": "yes" or "no", 
    "2": "yes" or "no", 
    "...", 
    "9": "yes" or "no" 
} 
**Guidelines**: 
- **Detect Even Small Parts**: If any part of the object is present, no matter how small, label the cell as "yes". 
- **Avoid False Positives**: Ensure that you base your "yes" decisions on actual visual evidence of the object in the cell. 
- **Precision**: Do not assume the object's presence without clear visual confirmation, even if adjacent cells contain the object. 
- **Clarity**: Keep your reasoning concise and focused on the key visual details observed in the cell. 
**Example**: 
{ 
    "reasoning_steps": [ 
        "Cell 1: A small portion of the object's distinctive edge is visible in the top-left corner.", 
        "Cell 2: No identifiable features of the object are present in this cell.", 
        "...", 
        "Cell 9: The object's unique color pattern is partially visible along the cell's border." 
    ], 
    "1": "yes", 
    "2": "no", 
    "...", 
    "9": "yes" 
}

# Prompt 6
You are an advanced object detection model. 
**Task**: 
Using the full image provided, determine whether any part of the specified object is present in each of 9 grid cells. 
**Object to Detect**: 
<object>{obj}</object> 
**Input**: 
- You will be given the full image containing the object. 
- The image is divided into a 3x3 grid, creating 9 cells numbered from 1 to 9 (left to right, top to bottom). You will be provided with 9 crops, each representing one of these cells. 
- Each cell may contain all, part, or none of the object. 
**Instructions**: 
1. **Analyze the Full Image**: 
 - Begin by examining the full image to understand the object's location, size, and features. 
2. **Evaluate Each Grid Cell**: 
 - For each cell (1 to 9): 
 - Determine if any part of the object is present within that cell. 
 - Look for distinguishing features such as shape, color, texture, or patterns. 
 - Consider partial appearances and overlapping regions. 
 - Decide whether to label the cell as containing the object ("yes") or not ("no"). 
**Output Format**: 
Present your findings in the following JSON format: 
{ 
    "1": "yes" or "no", 
    "2": "yes" or "no", 
    "...", 
    "9": "yes" or "no" 
} 
``` 
**Guidelines**: 
- **Accuracy**: Base your decisions strictly on visual evidence from the image. 
- **Clarity**: Keep your analysis concise and focused on the most significant features. 
- **Objectivity**: Do not incorporate external knowledge or assumptions beyond the provided image. 
- **Consistency**: Ensure your analysis aligns with your final decision for each cell.

# Prompt 7
You are an advanced object detection model. Your task is to detect the presence of a specified object within a set of grid cells. 
**Target Object**: 
<object>{obj}</object> 
 
**Grid Information**: 
- You will analyze 9 grid cells, indexed from 1 to 9, representing sections of a larger image. 
- Each cell may contain all, part, or none of the target object. 
**Your Objectives**: 
1. **Analyze Each Cell Individually**: 
   - Examine the visual content of each grid cell carefully. 
   - Look for any features, patterns, or fragments associated with the target object. 
2. **Determine Presence of the Object**: 
   - Decide whether any part of the target object is present in each cell. 
   - Your answer should be "yes" if any portion of the object is detected, or "no" if the object is absent. 
**Output Format**: 
Present your findings in the following JSON format: 
{ 
    "1": "yes" or "no", 
    "2": "yes" or "no", 
    ... 
    "9": "yes" or "no" 
}
