# Prompt 1
 Locate the {obj} and represent the location of the region. Regions are represented by [x1, y1, x2, y2] coordinates. x1 x2  
are the left-most and right-most points of the region, normalized into 0 to {normalization}, where 0 is the left and {normalization} is the right. y1 y2 are the  
top-most and bottom-most points of the region, normalized into 0 to {normalization}, where 0 is the top and {normalization} is the bottom.  
The output should be in JSON format, structured as follows: {"coordinates": [x1, y1, x2, y2]}

# Prompt 2
You are an AI assistant tasked with detecting objects in images. Your goal is to locate a specific object within an image description and represent its location using normalized coordinates. 
Your task is to locate the following object in the image: 
<object>{obj}</object> 
When representing the location of the object, use the following coordinate system: 
- The coordinates should be in the format [x1, y1, x2, y2] 
- x1 and x2 represent the left-most and right-most points of the region 
- y1 and y2 represent the top-most and bottom-most points of the region 
- All coordinates should be normalized to a range of 0 to {normalization} 
- For x-coordinates: 0 represents the left edge of the image, and {normalization} represents the right edge 
- For y-coordinates: 0 represents the top edge of the image, and {normalization} represents the bottom edge 
Your output should be in a JSON, structured as under: 
{ 
    "coordinates": [x1, y1, x2, y2] 
}

# Prompt 3
Your task is to precisely locate the object described below in the given image and represent its position using a normalized bounding box. 
<object>{obj}</object> 
### Bounding Box Representation: 
The bounding box should be represented as [x1, y1, x2, y2] where: 
- **x1** is the left-most point of the object 
- **x2** is the right-most point of the object 
- **y1** is the top-most point of the object 
- **y2** is the bottom-most point of the object 
All coordinates must be normalized according to the following system: 
- Horizontal coordinates (x1, x2) are scaled between 0 and {normalization}, where 0 represents the left edge of the image and {normalization} represents the right edge. 
- Vertical coordinates (y1, y2) are scaled between 0 and {normalization}, where 0 represents the top edge of the image and {normalization} represents the bottom edge. 
### Steps for Accurate Detection: 
1. **Analyze Object Boundaries**: Start by identifying the full extent of the object, including any irregular shapes, occlusions, or edges. Ensure that the entire object is contained within the bounding box. 
2. **Normalize Coordinates**: Carefully scale the coordinates of the bounding box to the 0 to {normalization} range, ensuring consistency and precision. 
3. **Refine for Accuracy**: Double-check to ensure the bounding box is correctly oriented and that the object is fully contained. 
### Output Format: 
Once you have determined the bounding box, provide the result in the following JSON format: 
{ 
    "reasoning_steps": [ 
        "Step 1: ...", 
        "Step 2: ...", 
        "Step 3: ..." 
    ] 
    "coordinates": [x1, y1, x2, y2], 
} 
### Additional Considerations: 
- Ensure that the bounding box fully captures the object without leaving any part outside the box. 
- Avoid unnecessary padding around the object. Keep the bounding box as tight as possible while still enclosing the object. 
- If the object is partially occluded, base the bounding box on the visible portion only. 
- The normalized coordinates should accurately represent the object's position within the image's full dimensions.

# Prompt 4
You are tasked with identifying and locating the following object within an image: 
<object>{obj}</object> 
### Your Objective: 
Locate the object in the image and create a bounding box that precisely captures its location, ensuring that the box is as tight as possible while including the entire object. If the object is occluded, focus only on the visible portion. 
### Bounding Box Instructions: 
- The bounding box should be represented as a list of four coordinates: [x1, y1, x2, y2]. 
- **x1** and **x2** are the left-most and right-most points of the object, respectively. 
- **y1** and **y2** are the top-most and bottom-most points of the object, respectively. 
All coordinates must be normalized to a range of 0 to {normalization}, where: 
- 0 represents the left/top edge of the image, and {normalization} represents the right/bottom edge. 
### Methodical Approach for Bounding Box Creation: 
1. **Identify the Full Extent of the Object**: Carefully analyze the object's shape and boundaries. Ensure you capture the entire object within the bounding box, considering occlusions or distortions. 
2. **Proportional Precision**: Ensure the bounding box aligns with the object's proportions. Avoid any unnecessary padding or cropping of important object features. 
3. **Coordinate Normalization**: Accurately translate the object's location into the normalized coordinate system, ensuring both x and y coordinates reflect the object's precise position relative to the full image dimensions. 
### Expected Output Format: 
Return your results in the following JSON format: 
{ 
    "reasoning_steps": [ 
        "Step 1: ...", 
        "Step 2: ...", 
        "Step 3: ..." 
    ] 
    "coordinates": [x1, y1, x2, y2], 
} 
### Additional Considerations: 
- Ensure that no parts of the object are left outside the bounding box. 
- The bounding box should be as tight as possible without cutting off important object features. 
- If any part of the object is occluded, base the bounding box on what is visible and clearly define the visible boundaries. 
- Avoid including any unnecessary background space. Only enclose the object itself within the bounding box.

# Prompt 5
You are an AI assistant tasked with detecting objects in images. Your goal is to locate a specific object within an image description and represent its location using normalized coordinates. 
Your task is to locate the following object in the image: 
<object>{obj}</object> 
When representing the location of the object, use the following coordinate system: 
- The coordinates should be in the format [y_min, x_min, y_max, x_max] 
- **y_min** and **y_max** represent the top-most and bottom-most points of the region 
- **x_min** and **x_max** represent the left-most and right-most points of the region 
Your output should be in a JSON, structured as follows: 
{ 
    "coordinates": [y_min, x_min, y_max, x_max] 
}