# Hassenstein-Reichardt detector experiment

Go to the folder ```reichardt_detector_experiment``` and run ```python reichardt_detector.py```

# Toy experiment

Go to the folder ```toy_experiment``` and run ```python toy_experiment.py```

# ImageNet experiment

Go to the folder ```imagenet_experiment``` and run 

```python image_quantitative.py --data_dir /datasets/imagenet --model vgg19 --model_layer model.features[34] --batch_size 256 --patch_size 48 --patch_stride 16 --nr_patches 8 --seed 0```

or

```python image_quantitative.py --data_dir /datasets/imagenet --model resnet50 --model_layer model.layer4[2].conv3 --batch_size 256 --patch_size 48 --patch_stride 16 --nr_patches 8 --seed 0```

# Bias experiment

Go to the folder ```bias_experiment``` and run

```python train.py --data_dir /datasets/ISIC2020 --store_dir /isic/models/ --model [default, presence_debias, presence_absence_debias] --init_path /models/xfixup_resnet50_model_best.pth.tar```

Once the models are trained, they can be evaluated with

```python eval.py --data_dir /datasets/ISIC2020 --store_dir /isic/models/ --model [default, presence_debias, presence_absence_debias]```