def adjust_coordinates(norm_pos_x, norm_pos_y, img_width=1088, img_height=1080):
    """Adjust normalized gaze coordinates to use the top-left as the origin."""
    x = norm_pos_x * img_width
    y = (1 - norm_pos_y) * img_height  # Adjust to flip y-coordinate
    return x, y

def generate_heatmap(points, img_width, img_height, sigma=50):
    """Generate a heatmap from a list of points with Gaussian filter."""
    heatmap = np.zeros((img_height, img_width))
    for x, y in points:
        x, y = int(round(x)), int(round(y))
        if 0 <= x < img_width and 0 <= y < img_height:
            heatmap[y, x] += 1  # Increment the heatmap at the point location

    # Apply Gaussian blur to the heatmap
    heatmap = gaussian_filter(heatmap, sigma=sigma)
    heatmap_normalized = (heatmap / heatmap.max() * 255).astype(np.uint8)
    return heatmap_normalized

def save_heatmap_image(heatmap, output_path):
    """Save the heatmap as an image."""
    heatmap_normalized = (heatmap / heatmap.max() * 255).astype(np.uint8)
    img = Image.fromarray(heatmap_normalized)
    img.save(output_path)

def overlay_heatmap_on_image(original_image_path, heatmap, output_path, alpha=0.3):
    """Overlay the heatmap on the original image and save it."""
    heatmap_image = Image.fromarray(np.uint8(plt.cm.hot(heatmap) * 255))  # Convert the heatmap to an RGBA image
    original_image = Image.open(original_image_path)

    if heatmap_image.size != original_image.size:
        heatmap_image = heatmap_image.resize(original_image.size, Image.LANCZOS)
    
    blended_image = Image.blend(original_image.convert('RGBA'), heatmap_image.convert('RGBA'), alpha=alpha)
    blended_image = blended_image.convert('RGB')
    blended_image.save(output_path)
    print(f"Saved blended image: {output_path}")