def process_optical_flow_and_gaze_correction(raft_model, frames_folder, gaze_file_path, output_folder, img_width=1088, img_height=1080, fps=30, delta_t=0.2):
    # frames = sorted(os.listdir(frames_folder))
    # Existing code
    frames = sorted(os.listdir(frames_folder), key=lambda x: (int(x.split('_')[0]), int(x.split('_')[1].split('.')[0])))
    for frame in frames:
        second, frame_number = map(int, frame.split('_')[0]), int(frame.split('_')[1].split('.')[0])
        frames_by_second[second].append(frame)
        
    frames_by_second = defaultdict(list)
    print(frames)

    # Group frames by second
    for frame in frames:
        second, frame_number = map(int, frame.split('_')[0]), int(frame.split('_')[1].split('.')[0])
        frames_by_second[second].append(frame)
    threshold = 10
    max_diff_proportion = 0.4

    gaze_data = {}
    with open(gaze_file_path, 'r') as file:
        reader = csv.DictReader(file)
        for row in reader:
            frame = int(row['frame'])
            x, y = adjust_coordinates(float(row['x']), float(row['y']), img_width, img_height)
            gaze_data[frame] = (x, y)

    all_corrected_gaze_points = []

    for second in sorted(frames_by_second.keys()):  # Ensure seconds are processed in order
        frames = sorted(frames_by_second[second], key=lambda x: int(x.split('_')[1].split('.')[0]))
        last_frame_path = os.path.join(frames_folder, frames[-1])
        last_frame = load_image(last_frame_path)
        print(last_frame_path)

        for frame in frames[:-1]:  # Exclude the last frame
            frame_path = os.path.join(frames_folder, frame)
            current_frame = load_image(frame_path)

            torch.cuda.empty_cache()

            flow_low1, flow_up1 = calculate_optical_flow(raft_model, current_frame, last_frame)
            flow_low2, flow_up2 = calculate_optical_flow(raft_model, last_frame, current_frame)
            flow_x1, flow_y1, flow1 = forward_interpolate(flow_low1[0])
            flow_x2, flow_y2, flow2 = forward_interpolate(flow_low2[0])
            height, width = flow_x1.shape[-2], flow_x1.shape[-1]
            num_diff_x = 0
            total_pixels = height * width
            for y in range(height):
                for x in range(width):
                    x_f = x + flow_x1[y, x].item()
                    y_f = y + flow_y1[y, x].item()

                    if 0 <= x_f < width and 0 <= y_f < height:
                        x_f = int(x_f)
                        y_f = int(y_f)
                        diff_x = abs((flow_x1[y, x].item()) + (flow_x2[ y_f, x_f].item()))
                        diff_y = abs((flow_y1[y, x].item()) + (flow_y2[ y_f, x_f].item()))
                        total_distance = math.sqrt(diff_x**2 + diff_y**2)

                        if total_distance > threshold:
                            num_diff_x +=1
                     
            
            proportion_diff_x = num_diff_x / total_pixels
            if proportion_diff_x > max_diff_proportion:
                continue

            flow_x1 = upsample_flow_component(flow_x1)
            flow_y1 = upsample_flow_component(flow_y1)

            frame_num = second * fps + int(frame.split('_')[1].split('.')[0])
            if frame_num in gaze_data:
                corrected_gaze = adjust_gaze_with_flow([gaze_data[frame_num]], flow_x1, flow_y1)[0]
                all_corrected_gaze_points.append(corrected_gaze)

    for second in range(0, len(frames) // fps):
        start_frame = max(0, (second + 1) * fps - int(delta_t * fps))
        end_frame = (second + 1) * fps
        corrected_points_for_second = [pt for idx, pt in enumerate(all_corrected_gaze_points) if start_frame <= idx < end_frame]
        if corrected_points_for_second:
            heatmap = generate_heatmap(corrected_points_for_second, img_width, img_height, sigma=40)
            save_heatmap_image(heatmap, os.path.join(output_folder, f'{second + 1}.jpg'))