# COMAL

This repository is for our paper "COMAL: A Convergent Meta-Algorithm for Aligning LLMs with General Preferences".

## Outline

- [How to Run](#how-to-run)
    - [Installation and Requirements](#installation-and-requirements)
    - [Running COMAL](#running-comal)
- [File Structure](#file-structure)
    - [Files](#files)
    - [Directories](#directories)

## How to Run

### Installation and Requirements
Please run `pip install -r requirements.txt` to install the required packages.

To run COMAL, you will likely need at least 8 GPUs with 48GB of memory each. The code is tested on a machine with 8 NVIDIA A6000 Ada GPUs.

### Running COMAL
To run COMAL, please use the following command: `bash comal.sh`.

The script [`comal.sh`](comal.sh) performs iterative preference optimization with the following steps:
1. Sampling candidate outputs from the LLM.
2. Scoring the candidate outputs using the preference model.
3. Data processing and precomputing the log probabilities of the output pairs.
4. Training: updating the LLM using INPO.
5. Evaluating the LLM.

## File Structure

### Files

- [`comal.sh`](comal.sh): Script for running COMAL.
- [`data_processing.py`](data_processing.py): Contains the code for post-processing the preference model annotations into training data for COMAL.
- [`data_utils.py`](data_utils.py): Utility functions for training data loading.
- [`eval.py`](eval.py): Evaluation script for COMAL.
- [`get_logprobs.py`](get_logprobs.py): Script for extracting log probabilities from an LLM/policy.
- [`losses.py`](losses.py): Loss functions for training COMAL.
- [`dpo.py`](dpo.py): DPO training.
- [`ipo.py`](ipo.py): IPO training.
- [`mle.py`](mle.py): MLE training.
- [`inpo.py`](inpo.py): INPO training.
- [`sampling.py`](sampling.py): Sampling candidate outputs from an LLM.
- [`scoring.py`](scoring.py): Scoring output pairs using a preference model.
- [`utils.py`](utils.py): Utility functions.
- [`vllm_model.py`](vllm_model.py): VLLM model definition.
- [`reward_model.py`](reward_model.py): Reward model definition.
- [`fsdp_config.yaml`](fsdp_config.yaml): Configuration file for FSDP.

### Directories
- [`data/prompts`](data/prompts): Contains the prompts used for training and evaluation.
- [`exps`](exps): Contains the results of the experiments. A new directory is created for each experiment, with the name specified in `comal.sh`.
- [`prompts`](prompts): Contains the prompt used for the preference model.
