# Diverse Exploration via InfomMax Options

Here are supplemental materials for our ICLR2021 blind submission
'Diverse Exploration via InfoMax Options'.

## Source Code
The `src` directory contains Python scripts we used for our experiments.
Required Python is 3.6.1 or newer.

We note some important files here:
- `a2imoc.py`: Implementation of A2IMOC
- `ppimoc.py`: Implementation of PPIMOC
- `run_4room.py`: CLI app for running Gridworld experiments
- `run_mujoco.py`: CLI app for running MuJoCo PointMaze experiments

All our dependencies are installed via installing `torch=1.5.0` and
three libraries we included in `src/lib`.
To install all dependencies, one can use `poetry install` or
`pip install -r requirements.txt`.

Here is a list of commands that we used for experiments:

- `python run_4rooms.py --envname=4RoomsExp -VB --agent-name=a2imoc --eval-times=4 train`
  - For Gridworld four rooms experiments.
  - To use other algorithm, please replase a2imoc with `aoc/our-aoc/a2c`.
- `python run_mjmaze.py --envname=Point4Rooms-v2 --logmu-weight-min=0.0 --eval-times=8 -SN --agent-name=ppimoc train`
  - For MuJoCo Point Four Rooms experiments.
  - To use other algorithm, please replase ppimoc with `ppoc/our-ppoc/ppo`.
- `python run_mjmaze.py --envname=PointBilliard-v2 --eval-times=8 -SN --logmu-weight-min=0.0 --max-steps=1 --beta-logit-clip=0.05 --agent-name=ppimoc train-and-adapt PointBilliard2/PointBilliard3/PointBilliard4`
  - For MuJoCo Point Billiard experiments.
  - Also, `ppoc/our-ppoc/ppo` are supported.


## Video
We included two videos
- `videos/ppimoc-four-rooms.mp4`
  - Learned PPIMOC agent in MuJoCo Point Four Rooms.
- `videos/ppimoc-billiard.mp4`
  - Learned PPIMOC agent in MuJoCo Point Billiard.
