# Random Number Generation

This folder contains the code necessary for replicating the experiments described in the section "Motivating example: Generating random numbers with LLMs" of our paper. These experiments demonstrate the effectiveness of different training methods in fine-tuning Large Language Models (LLMs) to generate random numbers from a specified distribution.

## Overview

The task involves training the LLM to generate random numbers in response to a specific prompt, such as '`The following is a random integer drawn uniformly between 0 and 100: '` The models are trained to match the target distribution as closely as possible. 

The experiments train variants of the same language model initialized from a pretrained checkpoint:

- Vanilla LM: Out-of-the-box pretrained LM (instruct GPT-J at half-precision, GPT-2)
- GFN-fine-tuned LM: Fine-tuned using Generative Flow Networks (GFN)
- Likelihood-trained LM: Fine-tuned using Supervised Fine-Tuning (SFT)
- RL-tuned LM: Fine-tuned using Proximal Policy Optimization (PPO)

## Repository Structure

```
rng/
│
├── rng_utils.py         # Utility functions for RNG tasks
├── rng_plot.py          # Visualization and plotting utilities
├── rng_dataset.py       # Dataset creation and management
├── rng_rewards.py       # Reward calculation for RL training
├── data_generator.py    # Script/functions to generate data samples
├── rng.png              # Mind map of an extended RNG experiment (going beyond the paper's)
│
├── configs/             # Directory for experimental configurations
│   └── config.yaml      # Main configuration file
│
└── notebooks/           # Jupyter notebooks for experiments and analysis
    ├── RNG_GFN.ipynb    # Experiments using GFlowNet (GFN)
    ├── RNG_PPO.ipynb    # Experiments using PPO training
    ├── RNG_SFT.ipynb    # Experiments with supervised fine-tuning (SFT)
    └── plots/           # Generated plots and visualizations
```

## Requirements

To run the code in this repository, the following are required

- Python 3.x
- Jupyter and IPykernel for the notebooks
- Hydra for configuring the experiments
- Core data science packages like NumPy, Pandas, Matplotlib, Seaborn
- PyTorch, Transformers and TRL for building and training the models
- Additional libraries, which can be installed via pip, including `tqdm` for progress bars and `Unidecode` for text formatting utilities, among others.

## Running the Experiments

1. Install the necessary Python packages.
2. Adjust the parameters in the `configs/config.yaml` file as needed.
3. Run the Jupyter notebooks in the `notebooks/` directory: `RNG_SFT.ipynb`, `RNG_PPO.ipynb`, `RNG_GFN.ipynb`.
    Each notebook follows a similar structure:
    - Introduction: A brief overview of the experiment.
    - General imports: Importing necessary libraries and modules.
    - Model setup: Loading the pre-trained LLM and setting up the fine-tuning process.
    - Experimentation: Fine-tuning the LLM and evaluating its performance.


Please note that fine-tuning the models may require a significant amount of computational resources and time. The results in the paper were obtained by running the experiments on a A100 GPU with 80GB of memory.

## Results

The results of the experiments are visualized in the Jupyter notebooks. They show the distribution of numbers generated by the LLMs before and after fine-tuning.