# Installation
* Requires Python >= 3.7.
* `pip install -e .`

# Run Point Mass Navigation
To run the obstacle version, substitue `pointmass` with `pointmass_obstacle`.

## Train Rewards
* BC-IRL-PPO `python imitation_learning/run.py +meta_irl=pointmass`
* GCL `python imitation_learning/run.py +gcl=pointmass`
* AIRL `python imitation_learning/run.py +airl=pointmass`
* MaxEnt `python imitation_learning/run.py +maxent=pointmass`
* f-IRL `python imitation_learning/run.py +f_irl=pointmass`

## Evaluate Rewards
To evaluate on the `eval` distribution add: `env=pointmass_eval`. Specify the path of the saved reward with `load_checkpoint=`.
* BC-IRL-PPO `python imitation-learning/eval.py +meta_irl=pointmass load_checkpoint=saved_reward.pth`
* GCL `python imitation_learning/eval.py +gcl=pointmass load_checkpoint=saved_reward.pth`
* AIRL `python imitation_learning/eval.py +airl=pointmass load_checkpoint=saved_reward.pth`
* MaxEnt `python imitation_learning/eval.py +maxent=pointmass load_checkpoint=saved_reward.pth`
* f-IRL `python imitation_learning/eval.py +f_irl=pointmass load_checkpoint=saved_reward.pth`
