# DriveGuard Video Review Tool

A web-based tool for manually reviewing and marking safety-critical clips from downloaded dashcam videos.

## Features

- **Drag-and-Drop Timeline**: Create clips by dragging them to the exact position on the timeline
- **Real-Time Video Preview**: See live video content while dragging clips to know exactly what you're marking
- **Multiple Clips Per Video**: Mark unlimited clips from each video with different categories and severities
- **Flexible Clip Duration**: Default 10 seconds, adjustable from 5-30 seconds or custom duration
- **Smart Video Queue**: Automatically discovers videos from the download folder with metadata integration
- **Progress Tracking**: Resume from last session, track completion across all videos
- **Skip/Complete Workflow**: Skip videos without useful content or mark as complete
- **Clip Management**: Edit, delete, play individual clips with severity levels and descriptions

## Quick Start

### Prerequisites

Ensure you have downloaded some videos using the YouTube downloader:

```bash
# Download videos first
uv run evaluation/make_dataset/s1_youtube_downloader.py --total-videos 50
```

### Start the Tool

```bash
# From project root
cd evaluation/make_dataset/s2_video_reviewer/
uv run main.py

# Or from project root with module path
uv run -m evaluation.make_dataset.s2_video_reviewer.main
```

### Open in Browser

Navigate to: http://localhost:8000

## Usage Workflow

### Basic Clip Marking

1. **Set Clip Duration**: Choose duration (default 10s) in header
2. **Add Clip**: Click "Add Clip" button to create a draggable clip at current video position  
3. **Drag to Position**: Drag the clip on timeline - video shows live preview of content
4. **Drop When Satisfied**: Drop clip when you see the right moment
5. **Multiple Clips**: Repeat for additional clips in the same video
6. **Complete/Skip**: Mark video as complete or skip if no useful content

### Video Navigation

- **Previous/Next**: Navigate between videos in queue
- **Skip Video**: Mark video as reviewed but not useful
- **No Clips**: Mark video as reviewed with no clips
- **Complete**: Mark video as complete (with or without clips)

### Clip Management

- **Edit Clips**: Click "Edit" button to modify category, description, severity, timing
- **Play Clips**: Click "Play" to preview just that clip segment
- **Delete Clips**: Right-click timeline clip or use delete button
- **Review All**: See all marked clips for current video in clips panel

### Keyboard Shortcuts

- **Space**: Play/pause video
- **A**: Add clip at current position
- **N**: Next video  
- **S**: Skip video
- **←/→**: Seek video backward/forward 5 seconds

## Interface Overview

### Header
- Progress indicator (current video / total videos)
- Clip duration selector
- Add clip button
- Total clips counter

### Video Section
- Video player with controls
- Video title and metadata display
- Timeline with draggable clips
- Real-time preview overlay during dragging

### Timeline
- Interactive canvas showing video timeline
- Draggable clip segments with visual feedback
- Click to seek video position
- Right-click clips for context menu

### Controls
- Navigation buttons (Previous, Skip, No Clips, Complete, Next)
- Playback speed control
- Export and review buttons

### Clips Panel
- List of all clips for current video
- Play, edit, delete actions per clip
- Severity indicators and descriptions
- Empty state with workflow instructions

## Data Storage

The tool stores clip markings in:
```
data/data_prepare/review_progress/
├── clip_markings.json      # All marked clips
├── review_state.json       # Session progress  
└── video_queue.json        # Video review queue
```

## Integration

### Read-Only Integration
- Discovers videos from `data/data_prepare/raw_videos/`
- Reads metadata from `.download_checkpoint.json`
- No modifications to existing files

### Export for Next Step
Clip markings are exported as JSON with all necessary information for video cutting:
- Video file paths
- Start/end times
- Categories and descriptions
- Severity levels

## Troubleshooting

### No Videos Found
```bash
# Check if videos directory exists
ls data/data_prepare/raw_videos/

# Download videos first if empty
uv run evaluation/make_dataset/01_youtube_downloader.py --total-videos 10
```

### Video Won't Load
- Check video file exists and is not corrupted
- Verify FastAPI server is running on port 8000
- Check browser console for errors

### Timeline Not Responsive
- Ensure JavaScript is enabled
- Try refreshing the page
- Check for console errors

### Clips Not Saving
- Check server logs for errors
- Verify write permissions to `data/data_prepare/review_progress/`
- Try exporting clips to see current state

## Technical Details

### Architecture
- **Backend**: FastAPI with video streaming and clip management API
- **Frontend**: HTML5 video player with custom drag-and-drop timeline
- **Timeline**: HTML5 Canvas with interactive clip visualization
- **Storage**: JSON files for persistence and export

### Browser Requirements  
- Modern browser with HTML5 video support
- JavaScript enabled
- Canvas and drag-and-drop API support

### Performance
- Videos served directly from filesystem
- Clips stored in memory during session
- Periodic saves to disk for persistence
- Timeline optimized for smooth dragging

## Development

### File Structure
```
s2_video_reviewer/
├── main.py              # FastAPI backend
├── models.py            # Data models
├── video_manager.py     # Video discovery & metadata
├── static/
│   ├── index.html       # Main interface
│   ├── app.js           # Application logic
│   ├── timeline.js      # Timeline component
│   └── styles.css       # UI styling
└── README.md            # This file
```

### Extending
- Add new clip categories in edit modal
- Customize timeline appearance in CSS
- Add new export formats in backend
- Integrate with external video analysis tools