"""
Application configuration settings
"""

from pydantic_settings import BaseSettings
from pathlib import Path
from typing import Optional


class Settings(BaseSettings):
    """Application settings with environment variable support"""
    
    # Directories
    video_directory: Path = Path(__file__).parent.parent.parent.parent.parent / "data" / "dashcam"
    ground_truth_directory: Path = Path(__file__).parent.parent.parent.parent.parent / "data" / "evaluation" / "ground_truth"
    sessions_directory: Path = Path(__file__).parent.parent.parent.parent.parent / "data" / "evaluation" / "sessions"
    backups_directory: Path = Path(__file__).parent.parent.parent.parent.parent / "data" / "evaluation" / "sessions" / "backups"
    
    # API Settings
    api_host: str = "0.0.0.0"
    api_port: int = 8000
    reload: bool = True
    
    # Session settings
    session_timeout: int = 3600  # 1 hour
    auto_save_interval: int = 300  # 5 minutes
    
    # Video processing
    max_video_size_mb: int = 500
    supported_formats: list = [".mp4", ".avi", ".mov", ".webm"]
    
    # Environment
    environment: str = "production"
    debug: bool = False
    
    class Config:
        env_file = ".env"
        env_prefix = "GT_ANNOTATION_"
    
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        # Create directories if they don't exist
        self.video_directory.mkdir(parents=True, exist_ok=True)
        self.ground_truth_directory.mkdir(parents=True, exist_ok=True)
        self.sessions_directory.mkdir(parents=True, exist_ok=True)
        self.backups_directory.mkdir(parents=True, exist_ok=True)