/**
 * Navigation Extension for Progress-Based Navigation
 * Extends the GroundTruthApp with progress-based clip navigation
 */

// Extend the app prototype once DOM is loaded
document.addEventListener('DOMContentLoaded', () => {
    
    // Add navigation mode toggle functionality
    GroundTruthApp.prototype.toggleNavigationMode = function() {
        // Toggle between 'progress' and 'sequential' navigation
        this.state.navigationMode = this.state.navigationMode === 'progress' ? 'sequential' : 'progress';
        
        // Update button text
        if (this.elements.navModeBtn) {
            const icon = this.state.navigationMode === 'progress' ? 'fa-tasks' : 'fa-list';
            const text = this.state.navigationMode === 'progress' ? 'Progress Mode' : 'Sequential Mode';
            this.elements.navModeBtn.innerHTML = `<i class="fas ${icon}"></i> ${text}`;
        }
        
        // Update navigation UI
        this.updateClipNavigation();
        
        console.log(`Switched to ${this.state.navigationMode} navigation mode`);
    };
    
    // Set up event listener for the navigation mode button after app initialization
    setTimeout(() => {
        if (window.app && window.app.elements.navModeBtn) {
            window.app.elements.navModeBtn.addEventListener('click', () => {
                window.app.toggleNavigationMode();
            });
        }
    }, 100);
});