import logging.config
from logging.handlers import TimedRotatingFileHandler
import colorlog
import datetime
import os
from yaml import safe_load
from pathlib import Path

from .settings import settings

def date_namer(filename):
    backend_dir = Path(__file__).parent.parent.parent
    log_dir = backend_dir / settings.app.path['log']
    log_dir.mkdir(parents=True, exist_ok=True) 
    log_filename = f"{log_dir.resolve().as_posix()}/{datetime.date.today()}.log"
    return log_filename

logging_config_file = Path(__file__).parent.parent.parent / "config" / "logging.yaml"
config = safe_load(logging_config_file.read_text())
config['handlers']['file']['filename'] = date_namer('')
logging.config.dictConfig(config)
for handler in logging.getLogger().handlers:
    if isinstance(handler, TimedRotatingFileHandler):
        handler.namer = date_namer
logger = logging.getLogger(settings.app.logger)