from pydantic import BaseModel, field_validator, ValidationError
from typing import Literal, Any, List
from yaml import safe_load
from pathlib import Path

yaml_file_path = Path(__file__).parent.parent.parent / "config" / "project.yaml"

class APPSettings(BaseModel):
    name: str
    version: str
    logger: Literal["development", "production", "staging"]
    llm: dict[str, str] 
    embedding: dict[str, str]
    path: dict[str, str]  
    setting: dict[str, Any]  

    @field_validator('llm')
    @classmethod
    def llm_must_be_supported(cls, v: dict[str, str]):
        supported = safe_load(yaml_file_path.read_text())['supported_models']['llm']
        for key, value in v.items():
            if value not in supported:
                raise ValueError(f"llm must be one of {supported}")
        return v

    @field_validator('embedding')
    @classmethod
    def embedding_must_be_supported(cls, v: dict[str, str]):
        supported = safe_load(yaml_file_path.read_text())['supported_models']['embedding']
        for key, value in v.items():
            if value not in supported:
                raise ValueError(f"llm must be one of {supported}")
        return v

class SupportedModels(BaseModel):
    llm: List[str]
    embedding: List[str] 

class Settings(BaseModel):
    llm_settings: dict[str, dict[str, Any]] 
    database: dict[str, dict[str, Any]]  
    app: APPSettings
    supported_models: SupportedModels

settings = Settings(**safe_load(yaml_file_path.read_text()))

