from pathlib import Path
root = Path(__file__).parent.parent
import sys
sys.path.append(str(root))

from src.llm.agent.traffic_accident_retriever import retrieve, traffic_accident_agent
from src.utils.log import logger

def test_traffic_accident_retriever():
    inputs = {
        "scene": "A car is speeding through a red light at an intersection."
    }
    res = retrieve(inputs)
    logger.info(f"{res['retrieved_accidents']}")


def test_traffic_accident_agent():
    inputs = {
        "scene": "A car is speeding through a red light at an intersection."
    }
    res = traffic_accident_agent.invoke(inputs)
    logger.info(f"{res['consequences']}")


if __name__ == "__main__":
    test_traffic_accident_agent()