import os
from neo4j import GraphDatabase

from src.utils.settings import settings
import src.llm    # for loading env variables

def test_neo4j_aura_connection():
    uri = settings.database['neo4j']['uri']
    database = settings.database['neo4j']['database']
    username = settings.database['neo4j']['username']
    password = os.getenv('NEO4J_PASSWORD')

    driver = GraphDatabase.driver(uri, auth=(username, password))

    with driver.session(database=database) as session:
        result = session.run("RETURN 1 AS test")
        assert result.single()["test"] == 1

    driver.close()


