# geometric_multivariate_kernel_ridge_regression

This is the repo for ICLR 2025 submission ID 8739
```
Learning vector fields of differential equations on manifolds with geometrically constrained operator-valued kernels
```

## Prerequisites

The code is developed and tested on a MacBook Pro Intel Core i7, Sonoma 14.5, with the following dependencies
```
python 3.8.6
matplotlib 3.3.0
numpy 1.22.4
scipy 1.9.3
sklearn 1.3.2
tqdm 4.59.0
```

To generate the baseline results, the following are required as well
```
jax 0.4.13
pysindy 1.7.5
candyman 1.0
torchdiffeq 0.2.2
LDNets
```
The particular CANDyMan repo we used is [this one](https://github.com/dfloryan/neural-manifold-dynamics/releases/tag/v1.0).
The package torchdiffeq is installed by pip.
The LDNets repo is obtained from [here](https://github.com/FrancescoRegazzoni/LDNets).

To test whether the package is functional, we suggest running `test/test.py`.
This would generate a few figures, and no error should be thrown.

## Case 1: 1D dynamics

(Figs. 1, 5, 6, 7)

### Figures 1 and 5

+ To generate the complete set of results, one needs to run the NODE and LDNet models first.
+ For NODE, open `test/s1_node.py`, choose the D parameter, and run the script to train the model.  Train the models for all 4 values of D.
+ For LDNet, copy `test/external/s1_ldnet.py` to `src` under LDNet repo, choose the D parameter, and run the script to train the model.  Train the models for all 4 values of D.  Copy the generated `res/s1_ldn_xx.npy` files from LDNet repo to `test/res/` in the current repo.
+ Run `test/s1.py` for Figs. 1 and 5

### Figures 6 and 7

+ Run `test/s1_lateral.py` directly; the provided script is self-contained.

## Case 2: Cavity flow

(Figs. 3, 8, 9)

### Data generation

+ This is the case where `pysindy` is required.
+ The data is available from [here](https://github.com/dynamicslab/pysindy/blob/master/examples/data/cavityPOD.mat).
+ Place the data file `cavityPOD.mat` in `test/data`.

### Results generation

The relevant script is `test/cavity.py`.

+ Set flags `iftst=0`, `ifnai, ifmsi, ifkrr = 1, 1, 1`, and `ifene=1` to run the script and generate Fig. 3(b).  (Rest flags are 0)
+ Set flags `iftst=1`, `ifnai, ifmsi, ifkrr = 1, 1, 1`, and `ifcnv, iftim, iferr = 1, 1, 1` to run the script and generate the other figures.  This run may take quite a while.  (Rest flags are 0)

## Case 3: KS beating dynamics

(Figs. 4(a,e,i), 10)

### Data generation

+ Use the data file [ksdataBeating.mat](https://github.com/dfloryan/neural-manifold-dynamics/blob/main/ksdataBeating.mat) from CANDyMan, and place it in `test/data`.
+ Run `test/data/ksdata.py` choosing `cas = 'beating'`.  This generates `test/data/ksdata_beating.pkl`.
+ To generate CANDyMan results, place `test/data/ksdata_beating.pkl` in the root of their repo.
+ Place our modified script `test/external/exampleKSbeating.py` in the CANDyMan repo, and run this script to generate its result file `ksb.pkl`.
+ Place `ksb.pkl` under `test/res`.

### Results generation

+ Run `test/ks_beat.py` as is.  This generates all results and plots all figures.

## Case 4: KS travelling dynamics

(Figs. 4(b,c,f,g,j,k), 11)

### Data generation

For CANDyMan

+ Use the data file [ksdataBeatingTravelling.mat](https://github.com/dfloryan/neural-manifold-dynamics/blob/main/ksdataBeatingTravelling.mat) from CANDyMan, and place it in `test/data`.
+ Run `test/data/ksdata.py` choosing `cas = 'travelling'`.  This generates `test/data/ksdata_travelling.pkl`.
+ To generate CANDyMan results, place `test/data/ksdata_travelling.pkl` in the root of their repo.
+ Place our modified script `test/external/exampleKSbeatingTravelling.py` in the CANDyMan repo, and run this script to generate its result file `kst.pkl`.
+ Place `kst.pkl` under `test/res`.

For LDNet

+ Place the same `ksdata_travelling.pkl` in `data` at the root of LDNet repo.
+ Place our script `test/external/ks_travel_ldnet.py` in `src` of LDNet repo.
+ Run `ks_travel_ldnet.py` as is, and place the resulting `res/ks_trf_ldn.pkl` under `test/res` of the current repo.

### Results generation

+ Run `test/ks_travel_fft.py` as is.  This generates the GMKRR-FFT results.
+ Run `test/ks_travel_node.py` as is.  This generates the NODE results.
+ Run `test/ks_travel.py` as is.  This generates all remaining results and plots all figures.

## Case 5: Reaction-diffusion dynamics

(Figs. 4(d,h,l), 12)

### Data generation

+ This is the case where `jax` is required.
+ Run `test/data/rddata.py` as is.  This generates `test/data/rddata.pkl`.
+ To generate CANDyMan results, place `test/data/rddata.pkl` in the root of their repo.
+ Place our modified script `test/external/exampleReactDifNeumann.py` in the CANDyMan repo, and run this script to generate its result file `rd.pkl`.
+ Place `rd.pkl` under `test/res`.

### Results generation

+ Run `test/rd_pca.py` with `ifkrr, ift4 = 1, 1`.  This generates the GMKRR-PCA-T4 results.
+ Run `test/rd_pca.py` with `ifkrr, ift4 = 1, 0`.  This generates the GMKRR-PCA-T0 results.
+ Run `test/rd.py` as is.  This generates all remaining results and plots all figures.
