## Usage

We undertake all the experiments using RTX 3090.

##### Dependencies

```
python=3.8
torch=1.12.0
einops=0.6.0
apex=0.1
```

##### Reproduction

1. Train and Eval
   We take LipConvNet-15 on CIFAR10 as an example.
   
   ```
   python train_robust.py --conv-layer soc --block-size 3 --dataset cifar10 --lln
   python train_robust.py --conv-layer cayley --block-size 3 --dataset cifar10 --lln --opt-level O0
   python train_robust.py --conv-layer bcop --block-size 3 --dataset cifar10 --lln
   python train_robust.py --conv-layer con_orth --block-size 3 --dataset cifar10 --lln
   ```
   
   To evaluate the certified robustness on the training set, undertake
   
   ```
   python evaluate_certificated_accuracy.py
   ```

2. Alter the Expressive Power
   
   Alter the expressive power of COCK by adjusting the amount of distinct kernel $k$ via handcrafting self.num and self.idx in con_orth.py, and adjusting the ONI steps $k$ via handcrafting self.oni in con_orth.py.
   

For each combination of dataset and model, we equip a combination of $t$ and $k$ for each layer. To be specific, we consider handcraft a certain ONI steps $t$ given $k$, which is uniform for all layers. That is, all layers under this combination own the same rule to match $t$ with $k$. Details can be seen in the following tabel.

| Dataset      | Model         | $t$   | $k$           |
| ------------ | ------------- | ----- | ------------- |
| CIFAR10      | LipConvNet-5  | 7     | 1,2,...,9     |
| CIFAR10      | LipConvNet-15 | 9     | 1,2,...,9     |
| CIFAR10      | LipConvNet-35 | 7 / 5 | 1 / 2,3,...,9 |
| CIFAR100     | LipConvNet-5  | 6     | 1,2,...,9     |
| CIFAR100     | LipConvNet-15 | 6     | 1,2,...,9     |
| CIFAR100     | LipConvNet-35 | 6 / 5 | 1 / 2,3,...,9 |
| TinyImageNet | LipConvNet-5  | 9     | 1,2,...,9     |
| TinyImageNet | LipConvNet-15 | 9     | 1,2,...,9     |
| TinyImageNet | LipConvNet-35 | 6     | 1,2,...,9     |

We can (qualitatively) traverse the expressive power of COCK, by setting the combination of $k$ ($\hat{k}$) for each combination of dataset and model. For example, consider the combination (CIFAR10, LipConvNet-15). We set $k$ for all the 15 layers respectively. The optimal results for certified robustness can be reproduced under the setting of $\hat{k}=(222,233,333,333,333)$. The 15 values in $\hat{k}$ represent the value of $k$ in each layer.
