# Adaptive Continual Learning

**-- Rapid Adaptation and Knowledge Refinement**

This repository is the official implementation of
[Adaptive Continual Learning].

![Illustration of LEARN](./store/figs/LEARN_illustration.png)

## Requirements

To install requirements, use the following command:

```setup
pip install -r requirements.txt
```

## Re-running the experiments

After installing the necessary requirements, you can re-run
the experiments as outlined below.

### Adaptive CL

```train
python main.py --config cifar10
python main.py --config cifar100
python main.py --config miniimagenet
python main.py --config tinyimagenet
```

### Ablation Study

To perform the ablation study
outlined in the paper, run the following command:

```train
python ablation.py
```


### Augmented CL with learning rate 0.001

```train
python main.py --config cifar10_augment --lr 0.001
python main.py --config cifar100_augment --lr 0.001
python main.py --config miniimagenet_augment --lr 0.001
```

## Citation

## Acknowledgments
