cifar10 = {
    "dataset_name": "cifar10",
    "cl_type": "regular",
    "n_tasks": 5,
    "n_classes": 10,
    "n_repeats": 80,
    "prune_min": 0.05,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "alpha": 0.9,
    "Lambda": 0.1,
    "lr": 1e-3,
    "buffer_size": 1000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

cifar100 = {
    "dataset_name": "cifar100",
    "cl_type": "regular",
    "n_tasks": 10,
    "n_classes": 100,
    "n_repeats": 20,
    "prune_min": 0.025,
    "alpha": 0.9,
    "Lambda": 0.1,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 1000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

miniimagenet = {
    "dataset_name": "miniimagenet",
    "cl_type": "regular",
    "n_tasks": 10,
    "n_classes": 100,
    "n_repeats": 20,
    "alpha": 0.1,
    "Lambda": 0.1,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 2000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

tinyimagenet = {
    "dataset_name": "tinyimagenet",
    "cl_type": "regular",
    "n_tasks": 10,
    "n_classes": 200,
    "n_repeats": 10,
    "alpha": 0.1,
    "Lambda": 0.1,
    "prune_min": 0.01,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 2000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

cub = {
    "dataset_name": "cub",
    "cl_type": "regular",
    "n_tasks": 10,
    "n_classes": 200,
    "n_repeats": 3,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

cifar10_augment = {
    "dataset_name": "cifar10",
    "cl_type": "augment",
    "times_augment": 3,
    "n_tasks": 2,
    "n_classes": 10,
    "n_repeats": 200,
    "prune_min": 0.05,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

cifar100_augment = {
    "dataset_name": "cifar100",
    "cl_type": "augment",
    "times_augment": 1,
    "n_tasks": 10,
    "n_classes": 100,
    "n_repeats": 40,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

miniimagenet_augment = {
    "dataset_name": "miniimagenet",
    "cl_type": "augment",
    "times_augment": 1,
    "n_tasks": 10,
    "n_classes": 100,
    "n_repeats": 40,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}
tinyimagenet_augment = {
    "dataset_name": "tinyimagenet",
    "cl_type": "augment",
    "times_augment": 1,
    "n_tasks": 20,
    "n_classes": 200,
    "n_repeats": 20,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

cub_augment = {
    "dataset_name": "cub",
    "cl_type": "augment",
    "times_augment": 9,
    "n_tasks": 10,
    "n_classes": 200,
    "n_repeats": 10,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

clinc150 = {
    "dataset_name": "clinc150",
    "cl_type": "regular",
    "n_tasks": 5,
    "n_classes": 150,
    "n_repeats": 5,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 3000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}

imagenet = {
    "dataset_name": "imagenet",
    "cl_type": "regular",
    "n_tasks": 20,
    "n_classes": 1000,
    "n_repeats": 10,
    "prune_min": 0.025,
    "patience_threshold": 10,
    "batch_size": 5,
    "gamma": 0.99,
    "mixing": 0.2,
    "lr": 1e-3,
    "buffer_size": 5000,
    "eta": 2,
    "agem_batch_size": 64,
    "cuda": True,
    "verbose": True,
    "seed": 42,
    "seed_len": 1,
}
