import torch

dataset_list = [
    # "cifar10",
    # "cifar100",
    # "miniimagenet",
    "tinyimagenet"
]
path = "./store/results/regular/"

for dataset_name in dataset_list:
    for name in [
        "Oracle",
        "Finetune",
        "ER",
        "ExpVAE",
        "AGEM",
        "OnlineEWC",
        "MIR",
        "Gdumb",
        "LEARN",
    ]:
        for seed in [42, 43]:
            for method in ["avg_acc", "adapt_acc", "test_acc_list"]:
                result_all = None
                filename = f"{path}{dataset_name}/{seed}/{name}_{method}.pt"
                result = torch.load(filename)

                if result_all is None:
                    result_all = result
                else:
                    if method == "adapt_acc":
                        result_all = result_all + result
                    else:
                        result_all = torch.cat((result_all, result), dim=1)

                torch.save(result_all, f"{path}{dataset_name}/{name}_{method}.pt")
