from eval.print_results import print_results
from eval.visualization import visualization


def show(cl_type="regular"):
    method_list = [
        "Oracle",
        "Finetune",
        "ER",
        "ExpVAE",
        "AGEM",
        "OnlineEWC",
        "MIR",
        "Gdumb",
        "LEARN",
    ]
    dataset_list = ["cifar10", "cifar100", "miniimagenet", "tinyimagenet"]
    for dataset_name in dataset_list:
        print("-" * 30, dataset_name, "-" * 30)
        print_results(
            cl_type=cl_type, dataset_name=dataset_name, method_list=method_list
        )
    # prepare visualization
    print("-" * 30, "visualization", "-" * 30)
    visualization(cl_type=cl_type, dataset_list=dataset_list, method_list=method_list)


if __name__ == "__main__":
    show("regular")
