# On the Relation between Gradient Directions and Systematic Generalization

## Main experiments
    # Multiclass classification: scripts in scripts/multiclass.
    # Please prepare data for non-dnn experiments.
    sh scripts/batch.sh scripts/multiclass/multiclass_dnn.sh

    # CelebA and CFQ: scripts in scripts/multiclass.
    # Please prepare data first.
    sh scripts/batch.sh scripts/main/main_dnn.sh

    # SGD experiments
    sh scripts/batch.sh scripts/sgd/sgd_fashion_dnn.sh

    # Disentangled input experiments
    sh scripts/batch.sh scripts/disentangled/disentangled_dnn_ood.sh

    # Plot DDR results: scripts in scripts/sgd.
    python3 summary.py --experiment_id multiclass_dnn --show_legend

## Data preparation
Please download and preprocess vision and text datasets.

### NICO++ dataset
Please download data from https://nicochallenge.com/dataset and put to ../../data/nico.

    python3 preprocess_data.py --dataset nico

### Amazon review dataset
Please download 5-core data for the following five categories from https://nijianmo.github.io/amazon/index.html and extract to ../../data/amazon.
- Books_5
- Clothing_Shoes_and_Jewelry_5
- Home_and_Kitchen_5
- Electronics_5
- Movies_and_TV_5

Please repeat the following preprocessing script for the five categories.

    python3 amazon_review_dataset.py --category Movies_and_TV_5

### Celeb dataset
Please download data from https://www.kaggle.com/datasets/jessicali9530/celeba-dataset and put to ../../data/celeba.

    python3 preprocess_data.py --dataset celeba

### CFQ dataset
Please download data from https://github.com/google-research/google-research/tree/master/cfq and put to ../../data/cfq.

    sh cfq_preprocess.sh
    python3 cfq_preprocess.py
    python3 cfq_preprocess.py --output
