#!/bin/bash
if [ $# -gt 0 ]; then
  SCRIPT=$1
else
  echo Script is not given.
  exit
fi

if [ $# -gt 1 ]; then
  GPU_ID=$2
else
  GPU_ID=0
fi

DEPTH=5

if [ "$(echo "${ID}" | grep -o partition)" = partition ]; then
  LAYERS="0 ${DEPTH}"
else
  LAYERS=$(seq ${DEPTH} ${DEPTH})
fi

SCRIPT_DIR=$(dirname "$(readlink -f "$0")")

for RANDOM_SEED in $(seq 5); do
  sh "${SCRIPT_DIR}"/wrapper.sh \
    "${SCRIPT}" \
    "${DEPTH}" \
    "${RANDOM_SEED}" \
    "${GPU_ID}"
done
