#!/usr/bin/env bash

if [ $# = 4 ]; then
  LOG_DIR=$1
  DEPTH=$2
  RANDOM_SEED=$3
  GPU_ID=$4
else
  echo log_dir, depth, random_seed, and gpu_id.
  exit
fi

echo \
  CUDA_VISIBLE_DEVICES="${GPU_ID}" \
  python3 -u main.py \
  --parameter_random_seed "${RANDOM_SEED}" \
  --data_random_seed "${RANDOM_SEED}" \
  --merge_type celeba \
  --model_type vit \
  --log_interval 200 \
  --batch_size 256 \
  --lr 0.001 \
  --steps 2000 \
  --n_hidden_nodes 64 \
  --depth "${DEPTH}" \
  --dataset mnist \
  --label_split diagonal \
  --test_sample_size 256 \
  --log_dir "${LOG_DIR}"
