#!/usr/bin/env bash

if [ $# -gt 0 ]; then
  SCRIPT=$1
else
  echo Script is not given.
  exit
fi

if [ $# -gt 1 ]; then
  DEPTH=$2
else
  DEPTH=0
fi

if [ $# -gt 2 ]; then
  RANDOM_SEED=$3
else
  RANDOM_SEED=1
fi

if [ $# -gt 3 ]; then
  GPU_ID=$4
else
  GPU_ID=0
fi

ID=$(basename "${SCRIPT}" | sed "s/.sh$//g")
ABS_PATH=$(readlink -f "${SCRIPT}")
cd "$(dirname "$(dirname "$(dirname "${ABS_PATH}")")")" || exit

EXPERIMENT_ID="${ID}_${RANDOM_SEED}"
LOG_DIR="logs/${ID}/${EXPERIMENT_ID}"
mkdir -p "${LOG_DIR}"
cp "${ABS_PATH}" "${LOG_DIR}"

command=$(sh "${SCRIPT}" \
  "${LOG_DIR}" \
  "${DEPTH}" \
  "${RANDOM_SEED}" \
  "${GPU_ID}")

echo "${command}" |
  sed 's/python/\\\n  python/g' |
  sed 's/--/\\\n  --/g' |
  tee "${LOG_DIR}"/command.txt

date >"${LOG_DIR}"/time.txt
eval "${command}" | tee "${LOG_DIR}"/log.txt
date >>"${LOG_DIR}"/time.txt
