
## Environment Setup

1. Install the Miniconda environment by following the instructions [here](https://docs.anaconda.com/miniconda/)

2. Create and activate conda virtual environment

```
conda create -n instant_cpu python=3.8
conda activate instant_cpu
```
3. Install requirements

```
pip install -r requirements.txt
```
4. Install CUDA 11.7

```
conda install -c "nvidia/label/cuda-11.7.1" cuda-toolkit
```

5. Install PyTorch 1.13.1

```
conda install pytorch==1.13.1 torchvision==0.14.1 pytorch-cuda=11.7 -c pytorch -c nvidia
```
  

### INSTANT Latency

0. To run the experiment, use:

```bash
bash test_cpu.sh
```

The output will be stored in `processed_time_cpu/`.

User can change model architecture, number of batch inside `test_cpu.sh`.
