# INSTANT: Compressing Gradients and Activations for Resource-Efficient Training of Transformer models
## Abstract: 
The explosive growth of the Internet of Things, characterized by billions of interconnected sensors, combined with the rapid advances of deep learning, has driven the emergence of Edge AI, a paradigm that enables real-time, on-device data processing, with improved privacy and reduced latency. Despite extensive research on on-device inference, training deep models directly on resource-constrained edge devices remains a significant challenge due to its high computational and memory requirements, which typically exceed the capacities of embedded systems. In this paper, we introduce INSTANT (compressIng gradieNts and activations for reSource-efficienT trAiniNg of Transformer models), a method designed to address both the computational and the memory bottlenecks in training Transformer-based architectures. INSTANT reduces resource demands during backpropagation by projecting gradients and activations into a low-rank subspace and performing computation within that compressed representation. Experimental results demonstrate that INSTANT achieves a $15\times$ reduction in computational cost and $32\times$ reduction in activation memory with negligible impact on model performance. The code will be made publicly available upon the paper's acceptance.

## Environment Setup
1. Create and activate conda environment
```bash
conda create -n instant python=3.8
conda activate instant
```
2. Install Pytorch 1.13.1 with CUDA 11.6:
```bash
conda install pytorch==1.13.1 torchvision==0.14.1 pytorch-cuda=11.6 -c pytorch -c nvidia
```

3. Install required library
```bash
pip install transformers datasets evaluate scikit-learn accelerate==1.0.1
```

## Train
Run `python train.py <args>` in your terminal.

Some common args:
- `--var`: The energy threshold use
- `--over_sampling`: The number of over sampling rank
- `--model_name`: Model used for fine-tuning

Training example:
```bash
bash train_example.sh
```
