#!/usr/bin/env bash
mindepth=0
maxdepth=1
case=tc

. utils/parse_options.sh

if [ $# -gt 1 ]; then
    echo "Usage: $0 --mindepth 0 --maxdepth 1 [exp]" 1>&2
    echo ""
    echo "Show the system environments and the evaluation results in Markdown format."
    echo 'The default of <exp> is "exp/".'
    exit 1
fi

[ -f ./path.sh ] && . ./path.sh
set -euo pipefail
if [ $# -eq 1 ]; then
    exp=$1
else
    exp=exp
fi


cat << EOF
<!-- Generated by $0 -->
# RESULTS
## Environments
- date: \`$(LC_ALL=C date)\`
EOF

python3 << EOF
import sys, espnet, torch
pyversion = sys.version.replace('\n', ' ')

print(f"""- python version: \`{pyversion}\`
- espnet version: \`espnet {espnet.__version__}\`
- pytorch version: \`pytorch {torch.__version__}\`""")
EOF

cat << EOF
- Git hash: \`$(git rev-parse HEAD)\`
  - Commit date: \`$(git log -1 --format='%cd')\`

EOF

# only show BLEU score for now
metrics="bleu"
while IFS= read -r expdir; do
    if ls "${expdir}"/*/*/score_*/result.${case}.txt &> /dev/null; then
        echo "## $(basename ${expdir})"
        for type in ${metrics}; do
            cat << EOF

### ${type^^}

|dataset|score|verbose_score|
|---|---|---|
EOF

            for result in "${expdir}"/*/*/score_"${type}"/result."${case}".txt; do
                inference_tag=$(echo "${result}" | rev | cut -d/ -f4 | rev)
                test_set=$(echo "${result}" | rev | cut -d/ -f3 | rev)
                score=$(sed -n '5p' "${result}" | cut -d ' ' -f 3 | tr -d ',')
                verbose=$(sed -n '7p' "${result}" | cut -d ' ' -f 3- | tr -d '",')
                echo "|${inference_tag}/${test_set}|${score}|${verbose}|"
            done
        done
    fi
done < <(find ${exp} -mindepth ${mindepth} -maxdepth ${maxdepth} -type d)
