#!/usr/bin/env bash
mindepth=0
maxdepth=1

. utils/parse_options.sh

if [ $# -gt 1 ]; then
    echo "Usage: $0 --mindepth 0 --maxdepth 1 [exp]" 1>&2
    echo ""
    echo "Show the system environments and the evaluation results in Markdown format."
    echo 'The default of <exp> is "exp/".'
    exit 1
fi

[ -f ./path.sh ] && . ./path.sh
set -euo pipefail
if [ $# -eq 1 ]; then
    exp=$1
else
    exp=exp
fi


cat << EOF
<!-- Generated by $0 -->
# RESULTS
## Environments
- date: \`$(LC_ALL=C date)\`
EOF

python3 << EOF
import sys, espnet, torch
pyversion = sys.version.replace('\n', ' ')

print(f"""- python version: \`{pyversion}\`
- espnet version: \`espnet {espnet.__version__}\`
- pytorch version: \`pytorch {torch.__version__}\`""")
EOF

cat << EOF
- Git hash: \`$(git rev-parse HEAD)\`
  - Commit date: \`$(git log -1 --format='%cd')\`

EOF

header_printed=false
while IFS= read -r expdir; do
    if ls "${expdir}"/*/scoring/metrics &> /dev/null; then
        echo "## $(basename ${expdir})"
        score_files=$(ls "${expdir}"/*/scoring/metrics)
        for score_file_ in ${score_files}; do
            if ! $header_printed; then
                cat "${score_file_}"
                header_printed=true
            else
                tail -n +3 "${score_file_}"
            fi
        done
        echo
    fi
done < <(find ${exp} -mindepth ${mindepth} -maxdepth ${maxdepth} -type d)
