import sys
from datetime import datetime

import torch

import espnet

if __name__ == "__main__":
    output_string = f"<!-- Generated by {sys.argv[0]} -->\n"
    output_string += "# RESULTS\n"
    output_string += "## Environments\n"
    output_string += f"date: {datetime.now()}\n\n"

    pyversion = sys.version.replace("\n", " ")
    output_string += f"- python version: {pyversion}\n"
    output_string += f"- espnet version: {espnet.__version__}\n"
    output_string += f"- pytorch version: {torch.__version__}\n\n"

    with open(sys.argv[1], "r") as f:
        lines = f.readlines()
    chunk = lines[0].strip().split(" ")
    trg_mean = float(chunk[1][:-1])
    trg_std = float(chunk[3])
    chunk = lines[1].strip().split(" ")
    nontrg_mean = float(chunk[1][:-1])
    nontrg_std = float(chunk[3])

    chunk = lines[2].strip().split(" ")
    eer = float(chunk[1][:-1])
    mindcf = float(chunk[3])

    output_string += "| | Mean | Std |\n|---|---|---|\n"
    output_string += f"| Target | {trg_mean:.4f} | {trg_std:.4f} |\n"
    output_string += f"| Non-target | {nontrg_mean:.4f} | {nontrg_std:.4f} |\n\n"

    output_string += "| Model name | EER(%) | minDCF |\n|---|---|---|\n"
    output_string += f"| {sys.argv[3]} | {eer:.3f} | {mindcf:.5f} |"

    with open(sys.argv[2], "w") as f:
        f.write(output_string)
