import sys
import os
import json
# Add the pipeline/ directory to sys.path
script_dir = os.path.dirname(os.path.abspath(__file__))
pipeline_root = os.path.abspath(os.path.join(script_dir, ".."))
sys.path.insert(0, pipeline_root)
from app.task.raw_tasks import *
# from app.Test_Driven.agent_test import *
from app.Test_Driven import *



# create Task
Task_example = RawLocalTask(
    env_name = "seaborn",
    task_id = "seaborn_example",
    local_repo = "REPOCOD/repocod_example/seaborn",
    issue_file = "REPOCOD/repocod_example/seaborn_problem.md"
)

# read test cases
task_data_path = "pipeline/app/Test_Driven/filtered_test/seaborn/seaborn_0.json"
with open(task_data_path, 'r') as f:
    task_data = json.load(f)
related_test_cases = task_data['filtered_test_dict']

# container_name
container_name = 'repocod_seaborn'

# set TestChecker
TestChecker_example = TestChecker(
    Task = Task_example,
    related_test_cases = related_test_cases,
    container_name = container_name
)


# generated code
gen_code = "    def label(\n        self,\n        formatter: Formatter | None = None, *,\n        like: str | Callable | None = None,\n        base: int | None | Default = default,\n        unit: str | None = None,\n    ) -> Continuous:\n        \"\"\"\n        Configure the appearance of tick labels for the scale's axis or legend.\n\n        Parameters\n        ----------\n        formatter : :class:`matplotlib.ticker.Formatter` subclass\n            Pre-configured formatter to use; other parameters will be ignored.\n        like : str or callable\n            Either a format pattern (e.g., `\".2f\"`), a format string with fields named\n            `x` and/or `pos` (e.g., `\"${x:.2f}\"`), or a callable with a signature like\n            `f(x: float, pos: int) -> str`. In the latter variants, `x` is passed as the\n            tick value and `pos` is passed as the tick index.\n        base : number\n            Use log formatter (with scientific notation) having this value as the base.\n            Set to `None` to override the default formatter with a log transform.\n        unit : str or (str, str) tuple\n            Use  SI prefixes with these units (e.g., with `unit=\"g\"`, a tick value\n            of 5000 will appear as `5 kg`). When a tuple, the first element gives the\n            separator between the number and unit.\n\n        Returns\n        -------\n        scale\n            Copy of self with new label configuration.\n\n        \"\"\"\n        import matplotlib.ticker as ticker\n\n        new = copy(self)\n\n        if formatter is not None:\n            new._label_params = {\"formatter\": formatter}\n            return new\n\n        if like is not None:\n            if isinstance(like, str):\n                if '{' in like:\n                    formatter = ticker.StrMethodFormatter(like)\n                else:\n                    formatter = ticker.FormatStrFormatter(like)\n            elif callable(like):\n                formatter = ticker.FuncFormatter(like)\n            else:\n                raise TypeError(\"`like` must be a string or callable.\")\n            new._label_params = {\"formatter\": formatter}\n            return new\n\n        if base is not default:\n            if base is None:\n                formatter = ticker.LogFormatterSciNotation()\n            else:\n                formatter = ticker.LogFormatter(base=float(base))\n            new._label_params = {\"formatter\": formatter}\n            return new\n\n        if unit is not None:\n            if isinstance(unit, tuple):\n                sep, unit = unit\n            else:\n                sep = \"\"\n            formatter = ticker.EngFormatter(unit=str(unit), sep=sep)\n            new._label_params = {\"formatter\": formatter}\n            return new\n\n        return new\n"


# test select test case functions: success
# selected_test = TestChecker_example.select_test_case()
# print(selected_test)
# exit()
TestChecker_example.selected_test_docker = '/usr/src/app/seaborn/tests/_core/test_scales.py::TestContinuous::test_label_type_checks'
TestChecker_example.selected_test_local = 'REPOCOD/repocod_example/seaborn/tests/_core/test_scales.py::TestContinuous::test_label_type_checks'


test_src_code_node, test_src_code = TestChecker_example.find_test_func(TestChecker_example.selected_test_local)
# example:
# print(TestChecker_example.selected_test_src_code)
    # def test_label_type_checks(self):
    #     s = Continuous()
    #     with pytest.raises(TypeError, match="Label formatter must be"):
    #         s.label("{x}")
    #     with pytest.raises(TypeError, match="`like` must be"):
    #         s.label(like=2)
# get the test result
test_result = TestChecker_example.run_test_in_docker()
# print(test_result)

test_prompt = TestChecker_example.build_error_prompt(gen_code)
print(test_prompt)


