#!/bin/bash
# make sure when you execute this script, the conda env is your approach env

# Change to the target working directory
cd pipeline || {
    echo "Directory does not exist!"
    exit 1
}

# Path to the file containing commands
CMD_FILE="REPOCOD/build_data/cmd4agent.txt"

# Check if the file exists
if [ ! -f "$CMD_FILE" ]; then
    echo "Command file not found: $CMD_FILE"
    exit 1
fi

# Execution loop
count=0
batch_size=10

while IFS= read -r line; do
    if [[ -n "$line" ]]; then
        echo "Executing: $line"
        eval "$line" &
        ((count++))
    fi

    if (( count % batch_size == 0 )); then
        echo "Batch of $batch_size commands launched. Waiting 10 seconds..."
        sleep 10
    fi
done < "$CMD_FILE"

# Optional: wait for all background jobs to finish
wait
echo "All commands executed."