You are working on a code generation task. You will be provided with:
1. The information of the target function
2. Access to the entire project for retrieval and analysis
3. Tests for the target function (if available)
Your task is to generate the function body of the target.

## Target Code Information:
TARGET_FUNCTION_LOCATION_DESCRIPTION
**Source Code:**:
```
FUNC_SIG_DOCSTR
```

## Test Information
You can call `search_test_cases` API to get detailed information.


## Task Instructions
The target function is currently unimplemented and contains only `raise NotImplementedError`.
You will have access to different APIs for context retrieval in the codebase. 
Please carefully read the above information and retrieve context wisely to understand the target behavior, 
and provide a complete solution for the target code.

REMEMBER:
1. Avoid importing additional packages or libraries unless they already exist or considered necessary.
2. Ensure your generated code has correct indentation and follows the same formatting style as the context.
3. Do not generate additional code or patches other than the above target function.
