from app.AstCheck.PyrightChecker import *
from app.search.search_backend import *
from app.data_structures import SearchResult

project_path = 'REPOCOD/repocod_example/seaborn/'
target_func = SearchResult(
    file_path='REPOCOD/repocod_example/seaborn/seaborn/_core/scales.py', 
    start=600, 
    end=649, 
    class_name='Continuous', 
    func_name='label', 
    code='''    def label(
        self,
        formatter: Formatter | None = None, *,
        like: str | Callable | None = None,
        base: int | None | Default = default,
        unit: str | None = None,
    ) -> Continuous:
        """
        Configure the appearance of tick labels for the scale's axis or legend.

        Parameters
        ----------
        formatter : :class:`matplotlib.ticker.Formatter` subclass
            Pre-configured formatter to use; other parameters will be ignored.
        like : str or callable
            Either a format pattern (e.g., `".2f"`), a format string with fields named
            `x` and/or `pos` (e.g., `"${x:.2f}"`), or a callable with a signature like
            `f(x: float, pos: int) -> str`. In the latter variants, `x` is passed as the
            tick value and `pos` is passed as the tick index.
        base : number
            Use log formatter (with scientific notation) having this value as the base.
            Set to `None` to override the default formatter with a log transform.
        unit : str or (str, str) tuple
            Use  SI prefixes with these units (e.g., with `unit="g"`, a tick value
            of 5000 will appear as `5 kg`). When a tuple, the first element gives the
            separator between the number and unit.

        Returns
        -------
        scale
            Copy of self with new label configuration.

        """
        if formatter is not None:
            return self.copy(formatter=formatter)

        if like is not None:
            if isinstance(like, str):
                formatter = Formatter(like)
            else:
                formatter = FuncFormatter(like)

        if base is not None and base is not default:
            formatter = LogFormatter(base=base)
        
        if unit is not None:
            # Assuming there's a utility to format with units
            formatter = Formatter(unit=unit)

        return self.copy(formatter=formatter)'''
        )

def test_example():
    pychecker = PyrightChecker(project_path, target_func)
    output_json_path = 'pyright_extracted_output.json'
    extracted_diagnostics = pychecker.check_func(output_json_path)
    # for ele in extracted_diagnostics:
    #     for key, value in ele.items():
    #         print(f'{key}: {value}')
    #     print('=======================')
    pyright_feedback, pass_or_not = pychecker.build_pyright_feedback(extracted_diagnostics)
    print(pyright_feedback)
    print('==================')
    print(pass_or_not)
    
    

            
            
            
 
if __name__ == '__main__':
    pass