import sys
import os
import json

# Add the pipeline/ directory to sys.path
script_dir = os.path.dirname(os.path.abspath(__file__))
pipeline_root = os.path.abspath(os.path.join(script_dir, ".."))
sys.path.insert(0, pipeline_root)

from app.search.search_backend import SearchBackend
from app.search.search_utils import *
from app.task.raw_tasks import RawLocalTask
from app.data_structures import BugLocation, SearchResult


def test_search_class(SB: SearchBackend,class_name: str):
    tool_result, search_res, bool_val = SB.search_class(class_name)
    print('------------')
    print(tool_result)
    print('------------')
    print(search_res)
    print('------------')
    print(bool_val)

def test_get_class_full_snippet(SB: SearchBackend, class_name: str):
    tool_result, search_res, bool_val = SB.get_class_full_snippet(class_name)
    print('------------')
    print(tool_result)
    print('------------')
    print(search_res)
    print('------------')
    print(bool_val)
    
    
def test_is_func_calls_target(example_json_path, target_func_name, target_class_name):
    
    candidate2 = SearchResult(
            file_path = 'REPOCOD/downloaded_repos/seaborn/tests/_core/test_scales.py', 
            start = None, 
            end = None, 
            class_name = 'TestContinuous', 
            func_name = 'test_log_tick_format_disabled', 
            code = "    def test_log_tick_format_disabled(self, x):\n\n        s = Continuous(trans=\"log\").label(base=None)._setup(x, Coordinate())\n        a = PseudoAxis(s._matplotlib_scale)\n        a.set_view_interval(20, 20000)\n        labels = a.major.formatter.format_ticks(a.major.locator())\n        for text in labels:\n            assert re.match(r\"^\\d+$\", text)\n"
        )
    flag2 = is_func_calls_target(candidate2, 'label', 'Continuous')
    if flag2:
        print(candidate2.code)
    
def test_search_target_usage_example(SB: SearchBackend):
    tool_result, search_res, bool_val = SB.search_target_usage_example(5)
    print('------------')
    print(tool_result)
    print('------------')
    print(search_res)
    print('------------')
    print(bool_val)


    
def test_get_test_cases(SB: SearchBackend):
    tool_result, search_res, bool_val = SB.get_test_cases()
    print(tool_result)
    print(len(search_res))





if __name__ == "__main__":
    prj_path = 'REPOCOD/Tasks4Agents/seaborn/seaborn_0/seaborn'
    issue_file = 'REPOCOD/Tasks4Agents/seaborn/seaborn_0/task_description.md'
    task_data_path = 'REPOCOD/Tasks4Agents/seaborn/seaborn_0/seaborn_0.json'
    task = RawLocalTask(
            task_id = "task_example",
            local_repo = prj_path,
            issue_file = issue_file,
            task_data_path = task_data_path
        )
    search_bk = SearchBackend(project_path = prj_path, task = task)
    
    # class_name = 'Version1'
    # test_search_class(search_bk,class_name)
    # test_get_class_full_snippet(search_bk,class_name)
    example_json_path = 'REPOCOD/Tasks4Agents/seaborn/seaborn_0/seaborn_0.json'
    target_func_name = "label"
    target_class_name = "Continuous"
    # test_search_target_usage_example(search_bk)
    test_get_test_cases(search_bk)