"""
Values of global configuration variables.
"""

# Overall output directory for results
output_dir: str = ""

# Max number of times context retrieval and all is tried
overall_retry_limit: int = 1

# # Experimental mode to add reproducer and reviewer into the workflow
# reproduce_and_review: bool = False

# timeout for test cmd execution, currently set to 5 min
test_exec_timeout: int = 300

models: list[str] = []

backup_model = ["deepseek-chat"] # ["gpt-4o-2024-08-06"]

# para added by huyiran
DATASET_NAME = 'RepoCod' # RepoCod, RepoEval

REPOCOD_WORK_DIR = '/usr/src/app/'
REPOCOD_LOCAL_DIR = 'REPOCOD/downloaded_repos/'

REPOEVAL_WORK_DIR = '/usr/src/app/'
REPOEVAL_LOCAL_DIR = 'code-rag-bench/Task4Agent/'


# upper bound of the number of conversation rounds for the agent
conv_round_limit: int = 15
conv_round_limit_in_debugger: int = 15
test_case_selection_mode = "diff_call"
# 'random': Random selection
# 'call_distance': Sort and classified by Call distance, select tests that directly call the target
# 'fail_signal': Select tests with fail signal
# 'complexity': select tests with least complexity
# "diff_call": select tests with diff direct call
test_num = 3 # 1,3,5,10
refine_round = 5 # refinement rounds
dataset_name = 'RepoCod' # RepoCod, RepoEval
test_in_retrieval = True # whether we enable test agent in retrieval
test_in_refine = True # whether we enable test agent in refinement
cost_limit: float = 0.5  # cost limit for the process, in dollars


# parameters that won't be used for code gen tasks, for now
# whether to perform sbfl
enable_sbfl: bool = False

# whether to perform our own validation
enable_validation: bool = False

# whether to do angelic debugging
enable_angelic: bool = False

# whether to do perfect angelic debugging
enable_perfect_angelic: bool = False


# A special mode to only save SBFL result and exit
only_save_sbfl_result: bool = False

# A special mode to only generate reproducer tests and exit
only_reproduce: bool = False

# A special mode to only evaluate a reproducer test
only_eval_reproducer: bool = False
