# Reproduce Experiments

This file contains instructions on how to reproduce the evaluation in [1].
We assume that HyPlan and its dependencies have already been built (see instruction in the `README.md` in the main directory).
Moreover, ensure that your current working directory is `experiments/` (i.e., the same directory that the README you are currently reading is located).

## Install Solvers

As we already outlined in the main README, HyPlan computes a PDDL planning instance for each HyperLTL verification instance.
These instances can then be solved by any planner that supports the PDDL language (possibly including non-deterministic action effects).
Note that the times reported in Table 1 in [1] include the cumulative time needed to construct the encoding **and** solve the planning problem. 

To reproduce the experiments, you need the following additional dependencies:

- [_Python_](https://www.python.org/): Used to run the evaluation and invoke the `translator-fond` script
- [_Scorpion_](https://github.com/jendrikseipp/scorpion): Used for classical planning
- [_MyND_](https://github.com/JackyCSer/MyNDPlanner): Used for fully-observable non-deterministic (FOND) planning
- [_oink_](https://github.com/trolando/oink): Used for solving parity games and compare with the approach from [2]

Build each of the above in any directory of your choosing. 
The evaluation script needs the **absolute** paths to each of these solvers. For _Scorpion_, this is the path to the `fast-downward.py` starter script, for _MyND_ is the path to the `mynd-1.0-SNAPSHOT.jar` jar file, and for _oink_ it is the `oink` binary.

Ensure that you have a working version of Python installed (tested with version 3.10.9). 
If, during the evaluation, a Python script fails because some package is not installed, simply install it using [pip](https://pypi.org/project/pip/).

## Execution Script
We provide a Python execution script `run_experiments.py` that runs all instances in Table 1 of [1]. 
**Before** running the script, insert the absolute to the three solvers in the script (lines 9-11).
Afterwards, run `python run_experiments.py` to run the experiments from Table 1 [1].
Note that this script will take up to an hour to complete (depending on your hardware).

You can find all the NuSMV systems used by the script in the `systems/` folder. 
For each system, the script generates 10 random formulas over the system's APs of the form `\exists \exists F \psi` and `\forall \exists F \psi`. 

### \exists\exists Instances
The script first runs the `\exists \exists F \psi` formulas (see the `run_hyplan_EE` function in `run_experiments.py`). 
For these instances, the script generates the PDDL encoding using HyPlan and passes it directly to the _Scorpion_ planner. 

### \forall\exists Instances
Afterward, it runs the `\forall \exists F \psi` formulas (see the `run_hyplan_FE` function in `run_experiments.py`).
For these instances, we (1) use HyPlan to compute the PDDL encoding; (2) invoke the `translator-fond`` script to compute an SAS instance; and (3) solve the SAS instance using the _MyND_ planner. 

### Comparing Parity Game 
For each instance, it also uses the parity-game-based encoding and solves using _oink_ (see the `run_pg` function in `run_experiments.py`).
The _HyPro_ tool presented in [2] only supports explicit-state systems and is thus not applicable to NuSMV models. 
To fairly compare our PDDL-based encoding with [2], we, therefore, included the parity-game encoding within HyPlan (using the `--pg` option).

### Output
For each system, the script prints the (average) time taken by PDDL-based and PG-based encoding (always including the time for constructing the encoding and solving it). 
It also reports the size of the PG (PG Size) and the number of predicates/actions/objects for the PDDL encoding (PDDL Size). 


## References  

[1] Non-Deterministic Planning for Hyperproperty Verification. Anonymous author(s). Under Review at ICAPS 2024.

[2] Prophecy Variables for Hyperproperty Verification. Raven Beutner and Bernd Finkbeiner. CSF 2021
